/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.result;

import org.github.gestalt.config.GestaltCore;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.processor.result.ResultProcessor;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ErrorsUtil;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=200)
public class ErrorResultProcessor
implements ResultProcessor {
    private static final System.Logger logger = System.getLogger(GestaltCore.class.getName());
    private GestaltConfig gestaltConfig;

    @Override
    public void applyConfig(GestaltConfig config) {
        this.gestaltConfig = config;
    }

    @Override
    public <T> GResultOf<T> processResults(GResultOf<T> results, String path, boolean isOptional, T defaultVal, TypeCapture<T> klass, Tags tags) throws GestaltException {
        if (ErrorsUtil.checkErrorsShouldFail(results, this.gestaltConfig)) {
            if (!isOptional) {
                throw new GestaltException("Failed getting config path: " + path + ", for class: " + klass.getName(), results.getErrors());
            }
            if (logger.isLoggable(this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional())) {
                String errorMsg = ErrorsUtil.buildErrorMessage("Failed getting config path: " + path + ", for class: " + klass.getName() + " returning empty Optional", results.getErrors());
                logger.log(this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional(), errorMsg);
            }
            return GResultOf.result(null);
        }
        if (results.hasErrors() && logger.isLoggable(System.Logger.Level.DEBUG)) {
            String errorMsg = ErrorsUtil.buildErrorMessage("Errors getting config path: " + path + ", for class: " + klass.getName(), results.getErrors());
            logger.log(System.Logger.Level.DEBUG, errorMsg);
        }
        return GResultOf.resultOf(results.results(), results.getErrors(), results.isDefault(), results.getMetadata());
    }
}

