/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.result;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.processor.result.ResultProcessor;
import org.github.gestalt.config.processor.result.ResultsProcessorService;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class ResultsProcessorManager
implements ResultsProcessorService {
    private List<ResultProcessor> resultProcessors;

    public ResultsProcessorManager(List<ResultProcessor> resultProcessors) {
        this.resultProcessors = new ArrayList<ResultProcessor>(resultProcessors);
        this.resultProcessors = this.orderedResultProcessors();
    }

    @Override
    public void addResultProcessors(List<ResultProcessor> resultProcessorSet) {
        this.resultProcessors.addAll(resultProcessorSet);
        this.resultProcessors = this.orderedResultProcessors();
    }

    private List<ResultProcessor> orderedResultProcessors() {
        return this.resultProcessors.stream().sorted((to, from) -> {
            ConfigPriority[] toAnnotation = (ConfigPriority[])to.getClass().getAnnotationsByType(ConfigPriority.class);
            int toValue = toAnnotation.length > 0 ? toAnnotation[0].value() : 1000;
            ConfigPriority[] fromAnnotation = (ConfigPriority[])from.getClass().getAnnotationsByType(ConfigPriority.class);
            int fromValue = fromAnnotation.length > 0 ? fromAnnotation[0].value() : 1000;
            return toValue - fromValue;
        }).collect(Collectors.toList());
    }

    @Override
    public <T> GResultOf<T> processResults(GResultOf<T> results, String path, boolean isOptional, T defaultVal, TypeCapture<T> klass, Tags tags) throws GestaltException {
        GResultOf<T> processedResults = results;
        for (ResultProcessor resultProcessor : this.resultProcessors) {
            processedResults = resultProcessor.processResults(processedResults, path, isOptional, defaultVal, klass, tags);
        }
        return processedResults;
    }
}

