/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.result.validation;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.observations.ObservationService;
import org.github.gestalt.config.processor.result.ResultProcessor;
import org.github.gestalt.config.processor.result.validation.ConfigValidator;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=300)
public class ValidationResultProcessor
implements ResultProcessor {
    private GestaltConfig gestaltConfig;
    private ObservationService observationService;
    private final List<ConfigValidator> configValidators;

    public ValidationResultProcessor() {
        this.configValidators = new ArrayList<ConfigValidator>();
        ServiceLoader<ConfigValidator> loader = ServiceLoader.load(ConfigValidator.class);
        loader.forEach(this.configValidators::add);
    }

    public ValidationResultProcessor(List<ConfigValidator> configValidators, ObservationService observationService) {
        this.configValidators = configValidators;
        this.observationService = observationService;
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        this.gestaltConfig = config;
        this.configValidators.forEach(it -> it.applyConfig(config));
    }

    @Override
    public <T> GResultOf<T> processResults(GResultOf<T> results, String path, boolean isOptional, T defaultVal, TypeCapture<T> klass, Tags tags) throws GestaltException {
        if (results.hasResults() && this.shouldValidate(klass)) {
            Object obj = results.results();
            List<ValidationError> errors = this.configValidators.stream().map(it -> it.validator(obj, path, klass, tags)).flatMap(it -> it.getErrors().stream()).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.updateValidationObservations(errors);
                if (!isOptional) {
                    throw new GestaltException("Validation failed for config path: " + path + ", and class: " + klass.getName(), errors);
                }
                return GResultOf.result(null);
            }
        }
        return results;
    }

    private <T> boolean shouldValidate(TypeCapture<T> klass) {
        return !klass.isAssignableFrom((Type)((Object)String.class)) && !ClassUtils.isPrimitiveOrWrapper(klass.getRawType());
    }

    private void updateValidationObservations(List<ValidationError> errors) {
        if (this.gestaltConfig != null && this.gestaltConfig.isObservationsEnabled() && this.observationService != null) {
            this.observationService.recordObservation("get.config.validation.error", errors.size(), Tags.of());
        }
    }
}

