/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.reload;

import java.util.ArrayList;
import java.util.List;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reload.ConfigReloadListener;
import org.github.gestalt.config.source.ConfigSourcePackage;

public abstract class ConfigReloadStrategy {
    private static final System.Logger logger = System.getLogger(ConfigReloadStrategy.class.getName());
    protected final List<ConfigReloadListener> listeners = new ArrayList<ConfigReloadListener>();
    protected ConfigSourcePackage source;

    protected ConfigReloadStrategy() {
    }

    protected ConfigReloadStrategy(ConfigSourcePackage source) {
        this.source = source;
    }

    public ConfigSourcePackage getSource() {
        return this.source;
    }

    public void setSource(ConfigSourcePackage source) throws GestaltConfigurationException {
        this.source = source;
    }

    public void registerListener(ConfigReloadListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigReloadListener listener) {
        this.listeners.remove(listener);
    }

    protected void reload() throws GestaltException {
        ArrayList<GestaltException> exceptions = new ArrayList<GestaltException>();
        if (this.source == null) {
            logger.log(System.Logger.Level.WARNING, "Attempting to reload a source but no source provided");
            return;
        }
        for (ConfigReloadListener it : this.listeners) {
            try {
                it.reload(this.source);
            }
            catch (GestaltException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new GestaltException(exceptions);
        }
    }
}

