/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.reload;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.github.gestalt.config.reload.CoreReloadListener;

public class CoreReloadListenersContainer {
    protected final List<WeakReference<CoreReloadListener>> listeners = new ArrayList<WeakReference<CoreReloadListener>>();

    public void registerListener(CoreReloadListener listener) {
        this.listeners.add(new WeakReference<CoreReloadListener>(listener));
    }

    public void removeListener(CoreReloadListener listener) {
        this.cleanup();
        this.listeners.removeIf(it -> it.get() == null || it.get() == listener);
    }

    private void cleanup() {
        this.listeners.removeIf(it -> it.get() == null);
    }

    public List<WeakReference<CoreReloadListener>> getListeners() {
        this.cleanup();
        return this.listeners;
    }

    public void reload() {
        this.cleanup();
        this.listeners.forEach(it -> {
            CoreReloadListener weakRef = (CoreReloadListener)it.get();
            if (weakRef != null) {
                weakRef.reload();
            }
        });
    }
}

