/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.secret.rules;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.github.gestalt.config.secret.rules.SecretObfuscator;

public class MD5SecretObfuscator
implements SecretObfuscator {
    private final MessageDigest md = MessageDigest.getInstance("MD5");

    @Override
    public String obfuscator(String value) {
        byte[] messageDigest = this.md.digest(value.getBytes(Charset.defaultCharset()));
        return this.convertToHex(messageDigest);
    }

    private String convertToHex(byte[] messageDigest) {
        BigInteger bigint = new BigInteger(1, messageDigest);
        String hexText = bigint.toString(16);
        while (hexText.length() < 32) {
            hexText = "0".concat(hexText);
        }
        return hexText;
    }
}

