/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.secret.rules;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.github.gestalt.config.secret.rules.SecretChecker;

public class RegexSecretChecker
implements SecretChecker {
    private final Set<Pattern> secretRegex;

    public RegexSecretChecker(String secretRegex) {
        this.secretRegex = Set.of(Pattern.compile(secretRegex));
    }

    public RegexSecretChecker(Set<String> secretRegex) {
        this.secretRegex = secretRegex.stream().map(Pattern::compile).collect(Collectors.toSet());
    }

    @Override
    public boolean isSecret(String value) {
        return this.secretRegex.stream().anyMatch(rule -> rule.matcher(value).find());
    }

    @Override
    public void addSecret(String rule) {
        this.secretRegex.add(Pattern.compile(rule));
    }
}

