/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.secret.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.github.gestalt.config.metadata.IsSecretMetadata;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.secret.rules.RegexSecretChecker;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.secret.rules.SecretObfuscator;

public class SecretConcealerManager
implements SecretConcealer {
    private final SecretObfuscator obfuscator;
    private final SecretChecker secretChecker;

    public SecretConcealerManager(Set<String> secretRegex, SecretObfuscator obfuscator) {
        this.secretChecker = new RegexSecretChecker(secretRegex);
        this.obfuscator = obfuscator;
    }

    public SecretConcealerManager(SecretChecker secretChecker, SecretObfuscator obfuscator) {
        this.secretChecker = secretChecker;
        this.obfuscator = obfuscator;
    }

    public SecretObfuscator getMask() {
        return this.obfuscator;
    }

    public void addSecretRule(String rule) {
        this.secretChecker.addSecret(rule);
    }

    @Override
    public String concealSecret(String path, String value, Map<String, List<MetaDataValue<?>>> metadata) {
        if (this.secretChecker.isSecret(path) || metadata.containsKey(IsSecretMetadata.SECRET) && metadata.get(IsSecretMetadata.SECRET).stream().anyMatch(it -> (Boolean)it.getMetadata())) {
            return this.obfuscator.obfuscator(value);
        }
        return value;
    }
}

