/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.security.encrypted;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.security.encrypted.EncryptedSecretConfigNodeProcessor;
import org.github.gestalt.config.security.encrypted.EncryptionUtils;

public class EncryptedLeafNode
extends LeafNode {
    private static final System.Logger logger = System.getLogger(EncryptedSecretConfigNodeProcessor.class.getName());
    public static final String ENCRYPTION_ALGORITHM = "AES/GCM/NoPadding";
    public static final int GCM_TAG_LENGTH = 16;
    public static final int GCM_IV_LENGTH = 12;
    private final SecretKey skey;
    private final byte[] encryptedData;

    public EncryptedLeafNode(byte[] encryptedData, SecretKey skey, Map<String, List<MetaDataValue<?>>> metaData) throws IllegalBlockSizeException, BadPaddingException {
        super("", metaData);
        this.skey = skey;
        this.encryptedData = encryptedData;
    }

    @Override
    public LeafNode duplicate(String value) {
        try {
            SecretKey secretKey = EncryptionUtils.generateKey(128);
            byte[] encryptedData = EncryptionUtils.encryptGcm(secretKey, value);
            return new EncryptedLeafNode(encryptedData, secretKey, this.metadata);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException ex) {
            logger.log(System.Logger.Level.ERROR, "Exception duplicating EncryptedLeafNode with error " + ex.getMessage() + " returning normal leaf");
            return new LeafNode(value, this.metadata);
        }
    }

    public static String decryptGcm(SecretKey skey, byte[] ciphertext) throws BadPaddingException, IllegalBlockSizeException {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            byte[] initVector = Arrays.copyOfRange(ciphertext, 0, 12);
            GCMParameterSpec spec = new GCMParameterSpec(128, initVector);
            cipher.init(2, (Key)skey, spec);
            byte[] plaintext = cipher.doFinal(ciphertext, 12, ciphertext.length - 12);
            return new String(plaintext, Charset.defaultCharset());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    public Optional<String> getValue() {
        try {
            return Optional.of(EncryptedLeafNode.decryptGcm(this.skey, this.encryptedData));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getValueInternal() {
        return this.getValue();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LEAF;
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        return Optional.empty();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedLeafNode)) {
            return false;
        }
        EncryptedLeafNode leafNode = (EncryptedLeafNode)o;
        return Objects.equals(this.getValue(), leafNode.getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.encryptedData);
    }

    @Override
    public String toString() {
        return this.printer("", null, new PathLexer());
    }

    @Override
    public String printer(String path, SecretConcealer secretConcealer, SentenceLexer lexer) {
        String nodeValue = "secret";
        if (secretConcealer != null) {
            nodeValue = secretConcealer.concealSecret(path, nodeValue, this.metadata);
        }
        return "EncryptedLeafNode{value='" + nodeValue + "'}";
    }
}

