/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.security.encrypted;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.metadata.IsEncryptedMetadata;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.secret.rules.RegexSecretChecker;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.security.encrypted.EncryptedLeafNode;
import org.github.gestalt.config.security.encrypted.EncryptedSecretModule;
import org.github.gestalt.config.security.encrypted.EncryptionUtils;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=400)
public class EncryptedSecretConfigNodeProcessor
implements ConfigNodeProcessor {
    private static final System.Logger logger = System.getLogger(EncryptedSecretConfigNodeProcessor.class.getName());
    private SecretChecker encryptedSecret = new RegexSecretChecker(Set.of());

    @Override
    public void applyConfig(ConfigNodeProcessorConfig config) {
        EncryptedSecretModule moduleConfig = config.getConfig().getModuleConfig(EncryptedSecretModule.class);
        if (moduleConfig == null) {
            logger.log(System.Logger.Level.DEBUG, "TemporarySecretModule has not been registered. if you wish to use the TemporarySecretConfigNodeProcessor then you must register an TemporarySecretModule config moduleConfig using the builder");
        } else {
            this.encryptedSecret = moduleConfig.getSecretChecker();
        }
    }

    @Override
    public GResultOf<ConfigNode> process(String path, ConfigNode currentNode) {
        Optional<String> valueOptional = currentNode.getValue();
        if (!(currentNode instanceof LeafNode) || valueOptional.isEmpty()) {
            return GResultOf.result(currentNode);
        }
        Map<String, List<MetaDataValue<?>>> metadata = currentNode.getMetadata();
        if (!(this.encryptedSecret.isSecret(path) || metadata.containsKey(IsEncryptedMetadata.ENCRYPTED) && !metadata.get(IsEncryptedMetadata.ENCRYPTED).stream().noneMatch(it -> (Boolean)it.getMetadata()))) {
            return GResultOf.result(currentNode);
        }
        Optional<String> optionalLeafNodeValue = ((LeafNode)currentNode).getValueInternal();
        if (optionalLeafNodeValue.isEmpty()) {
            return GResultOf.result(currentNode);
        }
        try {
            SecretKey secretKey = EncryptionUtils.generateKey(128);
            byte[] encryptedData = EncryptionUtils.encryptGcm(secretKey, optionalLeafNodeValue.orElse(""));
            return GResultOf.result(new EncryptedLeafNode(encryptedData, secretKey, metadata));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException ex) {
            return GResultOf.errors(new ValidationError.EncryptedNodeFailure(path, ex));
        }
    }
}

