/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.security.encrypted;

import java.util.HashSet;
import java.util.Objects;
import org.github.gestalt.config.secret.rules.RegexSecretChecker;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.security.encrypted.EncryptedSecretModule;

public final class EncryptedSecretModuleBuilder {
    private SecretChecker encryptedSecret = new RegexSecretChecker(new HashSet<String>());

    private EncryptedSecretModuleBuilder() {
    }

    public static EncryptedSecretModuleBuilder builder() {
        return new EncryptedSecretModuleBuilder();
    }

    public EncryptedSecretModuleBuilder setEncryptedSecret(SecretChecker encryptedSecret) {
        Objects.requireNonNull(encryptedSecret);
        this.encryptedSecret = encryptedSecret;
        return this;
    }

    public EncryptedSecretModuleBuilder addSecret(String regex) {
        this.encryptedSecret.addSecret(regex);
        return this;
    }

    public EncryptedSecretModule build() {
        return new EncryptedSecretModule(this.encryptedSecret);
    }
}

