/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.security.temporary;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.secret.rules.SecretConcealer;

public class TemporaryLeafNode
extends LeafNode {
    private final AtomicInteger accessCount;
    private LeafNode decoratedNode;

    public TemporaryLeafNode(LeafNode decoratedNode, int accessCount, Map<String, List<MetaDataValue<?>>> metadata) {
        super("", metadata);
        this.accessCount = new AtomicInteger(accessCount);
        this.decoratedNode = decoratedNode;
    }

    @Override
    public LeafNode duplicate(String value) {
        return new TemporaryLeafNode(new LeafNode(value, this.metadata), this.accessCount.get(), this.metadata);
    }

    @Override
    public Optional<String> getValue() {
        if (this.accessCount.get() > 0 && this.accessCount.getAndDecrement() > 0) {
            return this.decoratedNode.getValue();
        }
        this.decoratedNode = new LeafNode("", this.metadata);
        return Optional.empty();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LEAF;
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        return Optional.empty();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemporaryLeafNode)) {
            return false;
        }
        TemporaryLeafNode leafNode = (TemporaryLeafNode)o;
        return Objects.equals(this.decoratedNode.getValue(), leafNode.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.decoratedNode.getValue(), this.accessCount);
    }

    @Override
    public String toString() {
        return this.printer("", null, new PathLexer());
    }

    @Override
    public String printer(String path, SecretConcealer secretConcealer, SentenceLexer lexer) {
        String nodeValue = this.decoratedNode.getValue().orElse("");
        Map<String, List<MetaDataValue<?>>> nodeMetadata = this.decoratedNode.getMetadata();
        if (secretConcealer != null) {
            nodeValue = secretConcealer.concealSecret(path, nodeValue, nodeMetadata);
        }
        return "TemporaryLeafNode{value='" + nodeValue + "'}";
    }
}

