/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.security.temporary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.metadata.IsTemporaryMetadata;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.security.temporary.TemporaryLeafNode;
import org.github.gestalt.config.security.temporary.TemporarySecretModule;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;

@ConfigPriority(value=500)
public class TemporarySecretConfigNodeProcessor
implements ConfigNodeProcessor {
    private static final System.Logger logger = System.getLogger(TemporarySecretConfigNodeProcessor.class.getName());
    private final List<Pair<SecretChecker, Integer>> secretCounts = new ArrayList<Pair<SecretChecker, Integer>>();

    @Override
    public void applyConfig(ConfigNodeProcessorConfig config) {
        TemporarySecretModule moduleConfig = config.getConfig().getModuleConfig(TemporarySecretModule.class);
        if (moduleConfig == null) {
            logger.log(System.Logger.Level.DEBUG, "TemporarySecretModule has not been registered. if you wish to use the TemporarySecretConfigNodeProcessor then you must register an TemporarySecretModule config moduleConfig using the builder");
        } else {
            this.secretCounts.addAll(moduleConfig.getSecretCounts());
        }
    }

    @Override
    public GResultOf<ConfigNode> process(String path, ConfigNode currentNode) {
        Optional<Integer> optionalAccessCount;
        Optional<String> valueOptional = currentNode.getValue();
        if (!(currentNode instanceof LeafNode) || valueOptional.isEmpty()) {
            return GResultOf.result(currentNode);
        }
        Optional<Pair> isTemporarySecret = this.secretCounts.stream().filter(it -> ((SecretChecker)it.getFirst()).isSecret(path)).findFirst();
        Map<String, List<MetaDataValue<?>>> metadata = currentNode.getMetadata();
        if (isTemporarySecret.isEmpty() && !metadata.containsKey(IsTemporaryMetadata.TEMPORARY)) {
            return GResultOf.result(currentNode);
        }
        Integer accessCount = 0;
        if (isTemporarySecret.isPresent()) {
            accessCount = (Integer)isTemporarySecret.get().getSecond();
        }
        if (metadata.containsKey(IsTemporaryMetadata.TEMPORARY) && (optionalAccessCount = metadata.get(IsTemporaryMetadata.TEMPORARY).stream().map(it -> (Integer)it.getMetadata()).max(Integer::compareTo)).isPresent()) {
            accessCount = Math.max(accessCount, optionalAccessCount.get());
        }
        return GResultOf.result(new TemporaryLeafNode((LeafNode)currentNode, accessCount, metadata));
    }
}

