/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.security.temporary;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.github.gestalt.config.secret.rules.RegexSecretChecker;
import org.github.gestalt.config.secret.rules.SecretChecker;
import org.github.gestalt.config.security.temporary.TemporarySecretModule;
import org.github.gestalt.config.utils.Pair;

public final class TemporarySecretModuleBuilder {
    private List<Pair<SecretChecker, Integer>> secretCounts = new ArrayList<Pair<SecretChecker, Integer>>();

    private TemporarySecretModuleBuilder() {
    }

    public static TemporarySecretModuleBuilder builder() {
        return new TemporarySecretModuleBuilder();
    }

    public TemporarySecretModuleBuilder setSecretCounts(List<Pair<SecretChecker, Integer>> secretCounts) {
        Objects.requireNonNull(secretCounts);
        this.secretCounts = secretCounts;
        return this;
    }

    public TemporarySecretModuleBuilder addSecretCounts(List<Pair<SecretChecker, Integer>> secretCounts) {
        this.secretCounts.addAll(secretCounts);
        return this;
    }

    public TemporarySecretModuleBuilder addSecret(String regex) {
        this.secretCounts.add(new Pair<RegexSecretChecker, Integer>(new RegexSecretChecker(Set.of(regex)), 1));
        return this;
    }

    public TemporarySecretModuleBuilder addSecretWithCount(String secretRegex, Integer accessCount) {
        this.secretCounts.add(new Pair<RegexSecretChecker, Integer>(new RegexSecretChecker(Set.of(secretRegex)), accessCount));
        return this;
    }

    public TemporarySecretModuleBuilder addSecretWithCount(SecretChecker secretChecker, Integer count) {
        this.secretCounts.add(new Pair<SecretChecker, Integer>(secretChecker, count));
        return this;
    }

    public TemporarySecretModule build() {
        return new TemporarySecretModule(this.secretCounts);
    }
}

