/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.StringUtils;
import org.github.gestalt.config.utils.SystemWrapper;

public final class EnvironmentConfigSource
implements ConfigSource {
    public static final String ENV_VARS = "envVars";
    private final UUID id = UUID.randomUUID();
    private final boolean failOnErrors;
    private final String prefix;
    private final boolean ignoreCaseOnPrefix;
    private final boolean removePrefix;
    private final Tags tags;
    private final Pattern startsWith = Pattern.compile("^[^a-zA-Z0-9]");

    public EnvironmentConfigSource() {
        this("", false, false, false, Tags.of());
    }

    public EnvironmentConfigSource(boolean failOnErrors) {
        this("", false, false, failOnErrors, Tags.of());
    }

    public EnvironmentConfigSource(String prefix, boolean removePrefix) {
        this(prefix, false, removePrefix, false, Tags.of());
    }

    public EnvironmentConfigSource(String prefix, boolean ignoreCaseOnPrefix, boolean removePrefix) {
        this(prefix, ignoreCaseOnPrefix, removePrefix, false, Tags.of());
    }

    public EnvironmentConfigSource(String prefix) {
        this(prefix, false, true, false, Tags.of());
    }

    public EnvironmentConfigSource(String prefix, boolean ignoreCaseOnPrefix, boolean removePrefix, boolean failOnErrors) {
        this.failOnErrors = failOnErrors;
        this.prefix = prefix;
        this.ignoreCaseOnPrefix = ignoreCaseOnPrefix;
        this.removePrefix = removePrefix;
        this.tags = Tags.of();
    }

    @Deprecated(since="0.26.0", forRemoval=true)
    public EnvironmentConfigSource(String prefix, boolean ignoreCaseOnPrefix, boolean removePrefix, boolean failOnErrors, Tags tags) {
        this.failOnErrors = failOnErrors;
        this.prefix = prefix;
        this.ignoreCaseOnPrefix = ignoreCaseOnPrefix;
        this.removePrefix = removePrefix;
        this.tags = tags;
    }

    @Override
    public boolean failOnErrors() {
        return this.failOnErrors;
    }

    @Override
    public boolean hasStream() {
        return false;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        throw new GestaltException("Unsupported operation load stream on an EnvironmentConfigSource");
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public List<Pair<String, String>> loadList() {
        return SystemWrapper.getEnvVars().entrySet().stream().filter(envVar -> StringUtils.startsWith((String)envVar.getKey(), this.prefix, this.ignoreCaseOnPrefix)).map(envVar -> {
            String key = (String)envVar.getKey();
            if (this.removePrefix && this.startsWith.matcher(key = key.substring(this.prefix.length())).find()) {
                key = key.substring(1);
            }
            return new Pair<String, String>(key, (String)envVar.getValue());
        }).collect(Collectors.toList());
    }

    @Override
    public String format() {
        return ENV_VARS;
    }

    @Override
    public String name() {
        return ENV_VARS;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnvironmentConfigSource)) {
            return false;
        }
        EnvironmentConfigSource that = (EnvironmentConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

