/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.github.gestalt.config.builder.SourceBuilder;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.source.FileConfigSource;

public final class FileConfigSourceBuilder
extends SourceBuilder<FileConfigSourceBuilder, FileConfigSource> {
    private Path path;

    private FileConfigSourceBuilder() {
    }

    public static FileConfigSourceBuilder builder() {
        return new FileConfigSourceBuilder();
    }

    public Path getPath() {
        return this.path;
    }

    public FileConfigSourceBuilder setPath(Path path) {
        Objects.requireNonNull(path, "path must not be null when building a file config source");
        this.path = path;
        return this;
    }

    public File getFile() {
        return this.path.toFile();
    }

    public FileConfigSourceBuilder setFile(File file) {
        Objects.requireNonNull(file, "file must not be null when building a file config source");
        this.path = file.toPath();
        return this;
    }

    @Override
    public ConfigSourcePackage build() throws GestaltException {
        return this.buildPackage(new FileConfigSource(this.path));
    }
}

