/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class InputStreamConfigSource
implements ConfigSource {
    private final InputStream config;
    private final String format;
    private final UUID id = UUID.randomUUID();

    public InputStreamConfigSource(InputStream config, String format) throws GestaltException {
        this.config = config;
        if (config == null) {
            throw new GestaltException("The InputStream provided was null");
        }
        this.format = format;
        if (format == null) {
            throw new GestaltException("The InputStream format provided was null");
        }
    }

    @Override
    public boolean hasStream() {
        return true;
    }

    @Override
    public InputStream loadStream() {
        return this.config;
    }

    @Override
    public boolean hasList() {
        return false;
    }

    @Override
    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an StringConfigSource");
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public String name() {
        return "String format: " + this.format;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return Tags.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputStreamConfigSource)) {
            return false;
        }
        InputStreamConfigSource that = (InputStreamConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

