/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class KubernetesSecretConfigSource
implements ConfigSource {
    public static final String K8_SECRET_CONFIG = "k8Secret";
    private final Path path;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public KubernetesSecretConfigSource(File file) throws GestaltException {
        this(Objects.requireNonNull(file, "Kubernetes Secret file can not be null").toPath(), Tags.of());
    }

    @Deprecated(since="0.26.0", forRemoval=true)
    public KubernetesSecretConfigSource(File file, Tags tags) throws GestaltException {
        this(Objects.requireNonNull(file, "Kubernetes Secret file can not be null").toPath(), tags);
    }

    public KubernetesSecretConfigSource(Path path) throws GestaltException {
        this(path, Tags.of());
    }

    public KubernetesSecretConfigSource(Path path, Tags tags) throws GestaltException {
        this.path = this.validatePath(path);
        this.tags = tags;
    }

    private Path validatePath(Path path) throws GestaltException {
        Objects.requireNonNull(path, "Kubernetes Secret path can not be null");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new GestaltException("Kubernetes Secret path does not exist at: " + path);
        }
        if (this.isEmpty(path)) {
            throw new GestaltException("Kubernetes Secret path is empty: " + path);
        }
        return path;
    }

    private boolean isEmpty(Path path) throws GestaltException {
        boolean bl;
        block8: {
            DirectoryStream<Path> directory = Files.newDirectoryStream(path);
            try {
                boolean bl2 = bl = !directory.iterator().hasNext();
                if (directory == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directory != null) {
                        try {
                            directory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GestaltException("IOException while testing if path is empty.", e);
                }
            }
            directory.close();
        }
        return bl;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean hasStream() {
        return false;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        throw new GestaltException("Unsupported operation loadStream on an KubernetesFilesConfigSource");
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public List<Pair<String, String>> loadList() throws GestaltException {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            try (DirectoryStream<Path> directory = Files.newDirectoryStream(this.path);){
                for (Path secretFile : directory) {
                    if (!Files.isRegularFile(secretFile, new LinkOption[0])) continue;
                    String key = secretFile.getFileName().toString();
                    String value = Files.readString(secretFile);
                    Pair<String, String> secret = new Pair<String, String>(key, value);
                    results.add(secret);
                }
            }
            catch (IOException e) {
                throw new GestaltException("IOException while loading kubernetes secrets from path: " + this.path);
            }
        }
        return results;
    }

    @Override
    public String format() {
        return "mapConfig";
    }

    @Override
    public String name() {
        return "Kubernetes Secret source: " + this.path.toString();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KubernetesSecretConfigSource)) {
            return false;
        }
        KubernetesSecretConfigSource that = (KubernetesSecretConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

