/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.github.gestalt.config.builder.SourceBuilder;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.source.KubernetesSecretConfigSource;

public final class KubernetesSecretConfigSourceBuilder
extends SourceBuilder<KubernetesSecretConfigSourceBuilder, KubernetesSecretConfigSource> {
    private Path path;

    private KubernetesSecretConfigSourceBuilder() {
    }

    public static KubernetesSecretConfigSourceBuilder builder() {
        return new KubernetesSecretConfigSourceBuilder();
    }

    public Path getPath() {
        return this.path;
    }

    public KubernetesSecretConfigSourceBuilder setPath(Path path) {
        Objects.requireNonNull(path, "path must not be null when building a Kubernetes Secret config source");
        this.path = path;
        return this;
    }

    public File getFile() {
        return this.path.toFile();
    }

    public KubernetesSecretConfigSourceBuilder setFile(File file) {
        Objects.requireNonNull(file, "file must not be null when building a Kubernetes Secret config source");
        this.path = file.toPath();
        return this;
    }

    @Override
    public ConfigSourcePackage build() throws GestaltException {
        return this.buildPackage(new KubernetesSecretConfigSource(this.path));
    }
}

