/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class MapConfigSource
implements ConfigSource {
    public static final String MAP_CONFIG = "mapConfig";
    private final Map<String, String> customConfig;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public MapConfigSource(Map<String, String> customConfig) {
        this(customConfig, Tags.of());
    }

    @Deprecated(since="0.26.0", forRemoval=true)
    public MapConfigSource(Map<String, String> customConfig, Tags tags) {
        Objects.requireNonNull(customConfig, "Custom map must not be null");
        this.customConfig = customConfig;
        this.tags = tags;
    }

    @Override
    public boolean hasStream() {
        return false;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        throw new GestaltException("Unsupported operation load stream on an CustomConfigSource");
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public List<Pair<String, String>> loadList() {
        return this.customConfig.entrySet().stream().map(envVar -> new Pair<String, String>((String)envVar.getKey(), (String)envVar.getValue())).collect(Collectors.toList());
    }

    @Override
    public String format() {
        return MAP_CONFIG;
    }

    @Override
    public String name() {
        return MAP_CONFIG;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapConfigSource)) {
            return false;
        }
        MapConfigSource that = (MapConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

