/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.SystemWrapper;

public final class SystemPropertiesConfigSource
implements ConfigSource {
    public static final String SYSTEM_PROPERTIES = "systemProperties";
    private final UUID id = UUID.randomUUID();
    private final boolean failOnErrors;
    private final Tags tags;

    public SystemPropertiesConfigSource() {
        this(false);
    }

    public SystemPropertiesConfigSource(boolean failOnErrors) {
        this(failOnErrors, Tags.of());
    }

    @Deprecated(since="0.26.0", forRemoval=true)
    public SystemPropertiesConfigSource(Tags tags) {
        this(false, tags);
    }

    @Deprecated(since="0.26.0", forRemoval=true)
    public SystemPropertiesConfigSource(boolean failOnErrors, Tags tags) {
        this.failOnErrors = failOnErrors;
        this.tags = tags;
    }

    @Override
    public boolean failOnErrors() {
        return this.failOnErrors;
    }

    @Override
    public boolean hasStream() {
        return true;
    }

    @Override
    public InputStream loadStream() throws GestaltException {
        Properties properties = SystemWrapper.getProperties();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            properties.store(output, null);
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (IOException e) {
            throw new GestaltException("Exception while converting system properties to a InputStream", e);
        }
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public List<Pair<String, String>> loadList() {
        Properties properties = SystemWrapper.getProperties();
        return properties.entrySet().stream().map(prop -> new Pair<String, String>((String)prop.getKey(), (String)prop.getValue())).collect(Collectors.toList());
    }

    @Override
    public String format() {
        return SYSTEM_PROPERTIES;
    }

    @Override
    public String name() {
        return SYSTEM_PROPERTIES;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemPropertiesConfigSource)) {
            return false;
        }
        SystemPropertiesConfigSource that = (SystemPropertiesConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

