/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.tag;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.tag.Tag;

public final class Tags {
    private static final Tags DEFAULT_TAGS = new Tags(Set.of());
    private final Set<Tag> internalTags;

    private Tags(Set<Tag> tags) {
        this.internalTags = new HashSet<Tag>(tags);
    }

    public static Tags of() {
        return DEFAULT_TAGS;
    }

    public static Tags of(List<Tag> tags) {
        return new Tags(new HashSet<Tag>(tags));
    }

    public static Tags of(Set<Tag> tags) {
        return new Tags(new HashSet<Tag>(tags));
    }

    public static Tags of(Tag ... tag) {
        return new Tags(Arrays.stream(tag).collect(Collectors.toSet()));
    }

    public static Tags of(Tags ... tags) {
        return new Tags(Arrays.stream(tags).flatMap(it -> it.getTags().stream()).collect(Collectors.toSet()));
    }

    public static Tags of(String ... tagsVarg) throws GestaltException {
        if (tagsVarg.length % 2 != 0) {
            throw new GestaltException("Tags must have come in pairs, received odd number of tags: " + tagsVarg.length);
        }
        int capacity = Math.floorDiv(tagsVarg.length, 2);
        HashSet<Tag> tags = new HashSet<Tag>(capacity);
        for (int i = 0; i < tagsVarg.length; i += 2) {
            tags.add(Tag.of(tagsVarg[i], tagsVarg[i + 1]));
        }
        return new Tags(tags);
    }

    public Tags and(Tag ... tags) {
        if (Tags.blankVarargs(tags)) {
            return this;
        }
        HashSet<Tag> newTags = new HashSet<Tag>(this.internalTags.size() + tags.length);
        newTags.addAll(this.internalTags);
        newTags.addAll(new HashSet<Tag>(Arrays.asList(tags)));
        return new Tags(newTags);
    }

    public Tags and(Tags tags) {
        if (tags == null || tags.getTags() == null || tags.getTags().isEmpty()) {
            return this;
        }
        HashSet<Tag> newTags = new HashSet<Tag>(this.internalTags.size() + tags.getTags().size());
        newTags.addAll(this.internalTags);
        newTags.addAll(tags.getTags());
        return new Tags(newTags);
    }

    public boolean isSubsetOf(Tags tags) {
        return tags.internalTags.containsAll(this.internalTags);
    }

    private static boolean blankVarargs(Tag[] tags) {
        return tags == null || tags.length == 0 || tags.length == 1 && tags[0] == null;
    }

    public static Tags profile(String value) {
        return Tags.of(Tag.of("profile", value));
    }

    public static Tags profiles(String ... value) {
        if (value.length == 1) {
            return Tags.profile(value[0]);
        }
        return Tags.of(Arrays.stream(value).map(it -> Tag.of("profile", it)).collect(Collectors.toList()));
    }

    public static Tags environment(String value) {
        return Tags.of(Tag.of("environment", value));
    }

    public static Tags environments(String ... value) {
        if (value.length == 1) {
            return Tags.environment(value[0]);
        }
        return Tags.of(Arrays.stream(value).map(it -> Tag.of("environment", it)).collect(Collectors.toList()));
    }

    public Set<Tag> getTags() {
        return this.internalTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tags)) {
            return false;
        }
        Tags tags1 = (Tags)o;
        return this.internalTags.equals(tags1.internalTags);
    }

    public int hashCode() {
        return Objects.hash(this.internalTags);
    }

    public String toString() {
        return "Tags{" + this.internalTags + "}";
    }
}

