/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.utils.GResultOf;

public final class ErrorsUtil {
    private ErrorsUtil() {
    }

    public static String buildErrorMessage(String message, List<ValidationError> errors) {
        return message + "\n - " + ErrorsUtil.buildErrorMessage(errors);
    }

    public static String buildErrorMessage(List<ValidationError> errors) {
        return errors.stream().map(error -> "level: " + error.level() + ", message: " + error.description()).collect(Collectors.joining("\n - "));
    }

    public static <T> boolean checkErrorsShouldFail(GResultOf<T> results, GestaltConfig gestaltConfig) {
        if (results.hasErrors()) {
            return !results.getErrors().stream().allMatch(it -> ErrorsUtil.ignoreError(it, gestaltConfig)) || !results.hasResults();
        }
        return false;
    }

    public static boolean ignoreError(ValidationError error, GestaltConfig gestaltConfig) {
        if (error.level().equals((Object)ValidationLevel.WARN) && gestaltConfig.isTreatWarningsAsErrors()) {
            return false;
        }
        if (error instanceof ValidationError.ArrayMissingIndex && !gestaltConfig.isTreatMissingArrayIndexAsError()) {
            return true;
        }
        if (error.hasNoResults() && !gestaltConfig.isTreatMissingValuesAsErrors()) {
            return true;
        }
        if (error.level().equals((Object)ValidationLevel.MISSING_OPTIONAL_VALUE) && !gestaltConfig.isTreatMissingDiscretionaryValuesAsErrors()) {
            return true;
        }
        return error.level() == ValidationLevel.WARN || error.level() == ValidationLevel.DEBUG;
    }
}

