/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.metadata.MetaDataValue;

public final class GResultOf<T> {
    private final T results;
    private final List<ValidationError> errors;
    private final boolean isDefault;
    private final Map<String, List<MetaDataValue<?>>> metadata;

    private GResultOf(T results, List<ValidationError> errors, boolean isDefault, Map<String, List<MetaDataValue<?>>> metadata) {
        this.results = results;
        this.errors = Objects.requireNonNullElse(errors, Collections.emptyList());
        this.isDefault = isDefault;
        this.metadata = metadata;
    }

    public static <T> GResultOf<T> result(T answer) {
        return new GResultOf<T>(answer, Collections.emptyList(), false, Map.of());
    }

    public static <T> GResultOf<T> result(T answer, boolean isDefault) {
        return new GResultOf<T>(answer, Collections.emptyList(), isDefault, Map.of());
    }

    public static <T> GResultOf<T> errors(List<ValidationError> errors) {
        return new GResultOf<Object>(null, errors, false, Map.of());
    }

    public static <T> GResultOf<T> errors(ValidationError errors) {
        return new GResultOf<Object>(null, Collections.singletonList(errors), false, Map.of());
    }

    public static <T> GResultOf<T> resultOf(T answer, ValidationError errors) {
        return new GResultOf<T>(answer, List.of(errors), false, Map.of());
    }

    public static <T> GResultOf<T> resultOf(T answer, List<ValidationError> errors) {
        return new GResultOf<T>(answer, errors, false, Map.of());
    }

    public static <T> GResultOf<T> resultOf(T answer, List<ValidationError> errors, Map<String, List<MetaDataValue<?>>> metadata) {
        return new GResultOf<T>(answer, errors, false, metadata);
    }

    public static <T> GResultOf<T> resultOf(T answer, List<ValidationError> errors, boolean isDefault, Map<String, List<MetaDataValue<?>>> metadata) {
        return new GResultOf<T>(answer, errors, isDefault, metadata);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasErrors(ValidationLevel level) {
        return this.errors.stream().anyMatch(it -> it.level().equals((Object)level));
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public List<ValidationError> getErrors(ValidationLevel level) {
        return this.errors.stream().filter(it -> it.level().equals((Object)level)).collect(Collectors.toList());
    }

    public List<ValidationError> getErrorsNotLevel(ValidationLevel level) {
        return this.errors.stream().filter(it -> !it.level().equals((Object)level)).collect(Collectors.toList());
    }

    public boolean hasResults() {
        return this.results != null;
    }

    public T results() {
        return this.results;
    }

    public <X extends Throwable> void throwIfNoResults(Supplier<? extends X> exceptionSupplier) throws X {
        if (!this.hasResults()) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public <U> GResultOf<U> mapWithError(Function<T, U> resultFunction) {
        if (!this.hasResults()) {
            return GResultOf.errors(this.errors);
        }
        return GResultOf.resultOf(resultFunction.apply(this.results), this.errors, this.isDefault, this.metadata);
    }

    public <U> GResultOf<U> mapWithError(Function<T, U> resultFunction, ValidationError missingError) {
        if (!this.hasResults()) {
            if (this.hasErrors()) {
                return GResultOf.errors(this.errors);
            }
            return GResultOf.errors(missingError);
        }
        return GResultOf.resultOf(resultFunction.apply(this.results), this.errors, this.isDefault, this.metadata);
    }

    public List<MetaDataValue<?>> getMetadata(String key) {
        return this.metadata.get(key);
    }

    public Map<String, List<MetaDataValue<?>>> getMetadata() {
        return this.metadata;
    }

    public boolean hasMetadata(String key) {
        return this.metadata.containsKey(key);
    }
}

