/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

import java.util.List;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.ObjectToken;
import org.github.gestalt.config.token.TagToken;
import org.github.gestalt.config.token.Token;

public final class PathUtil {
    private PathUtil() {
    }

    public static String toPath(SentenceLexer lexer, List<Token> tokens) {
        StringBuilder pathBuilder = new StringBuilder();
        tokens.forEach(token -> {
            if (token instanceof ObjectToken) {
                if (pathBuilder.length() != 0) {
                    pathBuilder.append(lexer.getNormalizedDeliminator());
                }
                pathBuilder.append(((ObjectToken)token).getName());
            } else if (token instanceof ArrayToken) {
                pathBuilder.append(lexer.getNormalizedArrayOpenTag());
                pathBuilder.append(((ArrayToken)token).getIndex());
                pathBuilder.append(lexer.getNormalizedArrayCloseTag());
            } else if (token instanceof TagToken) {
                pathBuilder.append(((TagToken)token).getTag());
                pathBuilder.append(lexer.getNormalizedMapTag());
                pathBuilder.append(((TagToken)token).getValue());
            }
        });
        return pathBuilder.toString();
    }

    public static String pathForKey(SentenceLexer lexer, String path, String key) {
        return path == null || path.isEmpty() ? key : path + lexer.getNormalizedDeliminator() + key;
    }

    public static String pathForKey(SentenceLexer lexer, String path, List<String> pathParts) {
        return pathParts.stream().reduce(path, (collectPath, key) -> PathUtil.pathForKey(lexer, collectPath, key));
    }

    public static String pathForIndex(SentenceLexer lexer, String path, int index) {
        return path == null || path.isEmpty() ? PathUtil.forIndex(lexer, index) : path + PathUtil.forIndex(lexer, index);
    }

    public static String forIndex(SentenceLexer lexer, int index) {
        return lexer.getNormalizedArrayOpenTag() + index + lexer.getNormalizedArrayCloseTag();
    }
}

