/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import org.github.gestalt.config.utils.RecComponent;

public final class RecordUtils {
    private static final MethodHandle MH_IS_RECORD;
    private static final MethodHandle MH_GET_RECORD_COMPONENTS;
    private static final MethodHandle MH_GET_NAME;
    private static final MethodHandle MH_GET_TYPE;
    private static final MethodHandle MH_GET_GENERIC_TYPE;
    private static final MethodHandle MH_GET_DECLARED_ANNOTATION;
    private static final MethodHandle MH_GET_ACCESSOR;
    private static final MethodHandles.Lookup LOOKUP;

    private RecordUtils() {
    }

    public static boolean isRecord(Class<?> type) {
        try {
            return MH_IS_RECORD != null && MH_IS_RECORD.invokeExact(type);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not determine type (" + type + ")", t);
        }
    }

    public static <T> RecComponent[] recordComponents(Class<T> type, Comparator<RecComponent> comparator) {
        try {
            Object[] rawComponents = MH_GET_RECORD_COMPONENTS.invokeExact(type);
            RecComponent[] recordComponents = new RecComponent[rawComponents.length];
            for (int i = 0; i < rawComponents.length; ++i) {
                Object comp = rawComponents[i];
                recordComponents[i] = new RecComponent(MH_GET_NAME.invokeExact(comp), MH_GET_GENERIC_TYPE.invokeExact(comp), MH_GET_TYPE.invokeExact(comp), MH_GET_DECLARED_ANNOTATION.invokeExact(comp), MH_GET_ACCESSOR.invokeExact(comp), i);
            }
            if (comparator != null) {
                Arrays.sort(recordComponents, comparator);
            }
            return recordComponents;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not retrieve record components (" + type.getName() + ")", t);
        }
    }

    public static Object componentValue(Object recordObject, RecComponent recordComponent) {
        try {
            MethodHandle MH_get = LOOKUP.findVirtual(recordObject.getClass(), recordComponent.name(), MethodType.methodType(recordComponent.type()));
            return MH_get.invoke(recordObject);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not retrieve record components (" + recordObject.getClass().getName() + ")", t);
        }
    }

    public static <T> T invokeCanonicalConstructor(Class<T> recordType, RecComponent[] recordComponents, Object[] args) {
        try {
            Class[] paramTypes = (Class[])Arrays.stream(recordComponents).map(RecComponent::type).toArray(Class[]::new);
            MethodHandle MH_canonicalConstructor = LOOKUP.findConstructor(recordType, MethodType.methodType(Void.TYPE, paramTypes)).asType(MethodType.methodType(Object.class, paramTypes));
            return (T)MH_canonicalConstructor.invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not construct type (" + recordType.getName() + ")", t);
        }
    }

    static {
        MethodHandle MH_getAccessor;
        MethodHandle MH_getDeclaredAnnotation;
        MethodHandle MH_getGenericType;
        MethodHandle MH_getType;
        MethodHandle MH_getName;
        MethodHandle MH_getRecordComponents;
        MethodHandle MH_isRecord;
        LOOKUP = MethodHandles.lookup();
        try {
            Class<?> c = Class.forName("java.lang.reflect.RecordComponent");
            MH_isRecord = LOOKUP.findVirtual(Class.class, "isRecord", MethodType.methodType(Boolean.TYPE));
            MH_getRecordComponents = LOOKUP.findVirtual(Class.class, "getRecordComponents", MethodType.methodType(Array.newInstance(c, 0).getClass())).asType(MethodType.methodType(Object[].class, Class.class));
            MH_getName = LOOKUP.findVirtual(c, "getName", MethodType.methodType(String.class)).asType(MethodType.methodType(String.class, Object.class));
            MH_getType = LOOKUP.findVirtual(c, "getType", MethodType.methodType(Class.class)).asType(MethodType.methodType(Class.class, Object.class));
            MH_getGenericType = LOOKUP.findVirtual(c, "getGenericType", MethodType.methodType(Type.class)).asType(MethodType.methodType(Type.class, Object.class));
            MH_getDeclaredAnnotation = LOOKUP.findVirtual(c, "getDeclaredAnnotations", MethodType.methodType(Annotation[].class)).asType(MethodType.methodType(Annotation[].class, Object.class));
            MH_getAccessor = LOOKUP.findVirtual(c, "getAccessor", MethodType.methodType(Method.class)).asType(MethodType.methodType(Method.class, Object.class));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            MH_isRecord = null;
            MH_getRecordComponents = null;
            MH_getName = null;
            MH_getType = null;
            MH_getGenericType = null;
            MH_getDeclaredAnnotation = null;
            MH_getAccessor = null;
        }
        catch (IllegalAccessException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
        MH_IS_RECORD = MH_isRecord;
        MH_GET_RECORD_COMPONENTS = MH_getRecordComponents;
        MH_GET_NAME = MH_getName;
        MH_GET_TYPE = MH_getType;
        MH_GET_GENERIC_TYPE = MH_getGenericType;
        MH_GET_DECLARED_ANNOTATION = MH_getDeclaredAnnotation;
        MH_GET_ACCESSOR = MH_getAccessor;
    }
}

