/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.utils;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isInteger(String value) {
        return StringUtils.isInteger(value, 10);
    }

    public static boolean isInteger(String value, int radix) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        int length = value.length();
        int startAt = 0;
        if (value.charAt(0) == '-') {
            ++startAt;
        }
        if (length <= startAt) {
            return false;
        }
        for (int i = startAt; i < length; ++i) {
            if (Character.digit(value.charAt(i), radix) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isReal(String value) {
        return StringUtils.isReal(value, 10);
    }

    public static boolean isReal(String value, int radix) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        boolean hasDecimal = false;
        int length = value.length();
        int startAt = 0;
        if (value.charAt(0) == '-') {
            ++startAt;
        }
        if (length > startAt && value.charAt(startAt) == '.') {
            ++startAt;
            hasDecimal = true;
        }
        if (length <= startAt) {
            return false;
        }
        for (int i = startAt; i < length; ++i) {
            if (value.charAt(i) == '.' && !hasDecimal) {
                hasDecimal = true;
                continue;
            }
            if (Character.digit(value.charAt(i), radix) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }
}

