/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.git;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;

public final class GitConfigSource
implements ConfigSource {
    private final UUID id = UUID.randomUUID();
    private final Path localRepoDirectory;
    private final String configFilePath;
    private final Tags tags;
    private Git clonedRepo;

    public GitConfigSource(String repoURI, Path localRepoDirectory, String configFilePath, String branch, CredentialsProvider credentials, SshSessionFactory sshSessionFactory) throws GestaltException {
        this(repoURI, localRepoDirectory, configFilePath, branch, credentials, sshSessionFactory, Tags.of());
    }

    @Deprecated(since="0.26.0", forRemoval=true)
    public GitConfigSource(String repoURI, Path localRepoDirectory, String configFilePath, String branch, CredentialsProvider credentials, SshSessionFactory sshSessionFactory, Tags tags) throws GestaltException {
        if (repoURI == null) {
            throw new GestaltException("Must provide a git repo URI");
        }
        if (localRepoDirectory == null) {
            throw new GestaltException("Must provide a local directory to sync to");
        }
        if (configFilePath == null) {
            throw new GestaltException("Must provide a path to the configuration file");
        }
        this.localRepoDirectory = localRepoDirectory;
        this.configFilePath = configFilePath;
        this.tags = tags;
        this.initializeGitRepo(repoURI, localRepoDirectory, branch, credentials, sshSessionFactory);
    }

    private void initializeGitRepo(String repoURI, Path localRepoDirectory, String branch, CredentialsProvider credentials, SshSessionFactory sshSessionFactory) throws GestaltException {
        try {
            if (Files.exists(localRepoDirectory, new LinkOption[0]) && Files.exists(localRepoDirectory.resolve(".git"), new LinkOption[0])) {
                this.clonedRepo = Git.open((File)localRepoDirectory.toFile());
            } else {
                this.deleteLocalDirectory(localRepoDirectory);
                Files.createDirectories(localRepoDirectory, new FileAttribute[0]);
                CloneCommand builder = Git.cloneRepository().setURI(repoURI).setBranch(branch).setDirectory(localRepoDirectory.toFile());
                if (credentials != null) {
                    builder.setCredentialsProvider(credentials);
                } else if (sshSessionFactory != null) {
                    builder.setTransportConfigCallback(transport -> {
                        if (transport instanceof SshTransport) {
                            ((SshTransport)transport).setSshSessionFactory(sshSessionFactory);
                        }
                    });
                }
                this.clonedRepo = builder.call();
            }
            this.pullLatest(credentials, sshSessionFactory);
        }
        catch (IOException | GitAPIException e) {
            throw new GestaltException("unable to clone git repo to local machine with error " + e.getMessage(), (Exception)e);
        }
    }

    private void deleteLocalDirectory(Path dir) throws IOException {
        try (Stream<Path> pathStream = Files.walk(dir, new FileVisitOption[0]);){
            pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    private void pullLatest(CredentialsProvider credentials, SshSessionFactory sshSessionFactory) throws GitAPIException {
        if (sshSessionFactory != null) {
            SshSessionFactory.setInstance((SshSessionFactory)sshSessionFactory);
        }
        ((PullCommand)this.clonedRepo.pull().setCredentialsProvider(credentials)).call();
    }

    public boolean hasStream() {
        Path configFile = this.localRepoDirectory.resolve(this.configFilePath);
        return Files.exists(configFile, new LinkOption[0]);
    }

    public InputStream loadStream() throws GestaltException {
        Path configFile = this.localRepoDirectory.resolve(this.configFilePath);
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new GestaltException("unable to find config file at " + configFile.toAbsolutePath());
        }
        try {
            return Files.newInputStream(configFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GestaltException("Exception while trying to read file " + configFile.toAbsolutePath() + " with error " + e.getMessage(), (Exception)e);
        }
    }

    public boolean hasList() {
        return false;
    }

    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an GitConfigSource");
    }

    public String format() {
        return this.format(this.configFilePath);
    }

    private String format(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public String name() {
        return "Git Config Source key: " + this.configFilePath;
    }

    public UUID id() {
        return this.id;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitConfigSource)) {
            return false;
        }
        GitConfigSource that = (GitConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

