/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.git;

import java.nio.file.Path;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.github.gestalt.config.builder.SourceBuilder;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.git.GitConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;

public final class GitConfigSourceBuilder
extends SourceBuilder<GitConfigSourceBuilder, GitConfigSource> {
    private String repoURI;
    private Path localRepoDirectory;
    private String configFilePath;
    private String branch;
    private CredentialsProvider credentials;
    private SshSessionFactory sshSessionFactory;

    private GitConfigSourceBuilder() {
    }

    public static GitConfigSourceBuilder builder() {
        return new GitConfigSourceBuilder();
    }

    public GitConfigSourceBuilder setRepoURI(String repoURI) {
        this.repoURI = repoURI;
        return this;
    }

    public GitConfigSourceBuilder setLocalRepoDirectory(Path localRepoDirectory) {
        this.localRepoDirectory = localRepoDirectory;
        return this;
    }

    public GitConfigSourceBuilder setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
        return this;
    }

    public GitConfigSourceBuilder setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public GitConfigSourceBuilder setCredentials(CredentialsProvider credentials) {
        this.credentials = credentials;
        return this;
    }

    public GitConfigSourceBuilder setSshSessionFactory(SshSessionFactory sshSessionFactory) {
        this.sshSessionFactory = sshSessionFactory;
        return this;
    }

    public ConfigSourcePackage build() throws GestaltException {
        return this.buildPackage(new GitConfigSource(this.repoURI, this.localRepoDirectory, this.configFilePath, this.branch, this.credentials, this.sshSessionFactory));
    }
}

