/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.kotlin.decoder;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.kotlin.reflect.KTypeCapture;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/github/gestalt/config/kotlin/decoder/ByteDecoder;", "Lorg/github/gestalt/config/decoder/LeafDecoder;", "", "()V", "leafDecode", "Lorg/github/gestalt/config/utils/ValidateOf;", "path", "", "node", "Lorg/github/gestalt/config/node/ConfigNode;", "matches", "", "klass", "Lorg/github/gestalt/config/reflect/TypeCapture;", "name", "priority", "Lorg/github/gestalt/config/decoder/Priority;", "gestalt-kotlin"})
public final class ByteDecoder
extends LeafDecoder<Byte> {
    @NotNull
    public String name() {
        return "kByte";
    }

    @NotNull
    public Priority priority() {
        return Priority.HIGH;
    }

    public boolean matches(@NotNull TypeCapture<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return klass instanceof KTypeCapture ? ((KTypeCapture)klass).isAssignableFrom(Reflection.getOrCreateKotlinClass(Byte.TYPE)) : false;
    }

    @NotNull
    protected ValidateOf<Byte> leafDecode(@Nullable String path, @NotNull ConfigNode node) {
        ValidateOf validateOf;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ValidateOf results = null;
        String value = node.getValue().orElse("");
        if (value.length() == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            String string = value;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ValidateOf validateOf2 = ValidateOf.valid((Object)byArray[0]);
            Intrinsics.checkNotNullExpressionValue((Object)validateOf2, (String)"{\n            ValidateOf\u2026tCharset())[0])\n        }");
            validateOf = validateOf2;
        } else {
            ValidateOf validateOf3 = ValidateOf.inValid((ValidationError)((ValidationError)new ValidationError.DecodingByteTooLong(path, node)));
            validateOf = validateOf3;
            Intrinsics.checkNotNullExpressionValue((Object)validateOf3, (String)"{\n            ValidateOf\u2026)\n            )\n        }");
        }
        results = validateOf;
        return results;
    }
}

