/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.kotlin.decoder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClasses;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.kotlin.entity.DataClassCanNotBeConstructed;
import org.github.gestalt.config.kotlin.entity.DataClassHasNoConstructor;
import org.github.gestalt.config.kotlin.entity.DataClassMissingRequiredMember;
import org.github.gestalt.config.kotlin.reflect.KTypeCapture;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/github/gestalt/config/kotlin/decoder/DataClassDecoder;", "Lorg/github/gestalt/config/decoder/Decoder;", "", "()V", "decode", "Lorg/github/gestalt/config/utils/ValidateOf;", "path", "", "node", "Lorg/github/gestalt/config/node/ConfigNode;", "type", "Lorg/github/gestalt/config/reflect/TypeCapture;", "decoderService", "Lorg/github/gestalt/config/decoder/DecoderService;", "matches", "", "klass", "name", "priority", "Lorg/github/gestalt/config/decoder/Priority;", "gestalt-kotlin"})
public final class DataClassDecoder
implements Decoder<Object> {
    @NotNull
    public String name() {
        return "DataClass";
    }

    @NotNull
    public Priority priority() {
        return Priority.MEDIUM;
    }

    public boolean matches(@NotNull TypeCapture<?> klass) {
        KClassifier classifier;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        if (klass instanceof KTypeCapture && (classifier = ((KTypeCapture)klass).getKType().getClassifier()) instanceof KClass) {
            return ((KClass)classifier).isData();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValidateOf<Object> decode(@NotNull String path, @NotNull ConfigNode node, @NotNull TypeCapture<?> type, @NotNull DecoderService decoderService) {
        KClassifier classifier;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)decoderService, (String)"decoderService");
        if (!(node instanceof MapNode)) {
            ValidateOf validateOf = ValidateOf.inValid((ValidationError)((ValidationError)new ValidationError.DecodingExpectedLeafNodeType(path, node, this.name())));
            Intrinsics.checkNotNullExpressionValue((Object)validateOf, (String)"ValidateOf.inValid(Valid\u2026Type(path, node, name()))");
            return validateOf;
        }
        if (type instanceof KTypeCapture && (classifier = ((KTypeCapture)type).getKType().getClassifier()) instanceof KClass && ((KClass)classifier).isData()) {
            Object object;
            void $this$filterValues$iv;
            Object it;
            Map $this$associateWith$iv;
            if (((KClass)classifier).getConstructors().isEmpty()) {
                String string = ((KClass)classifier).getSimpleName();
                if (string == null) {
                    string = "";
                }
                ValidateOf validateOf = ValidateOf.inValid((ValidationError)new DataClassHasNoConstructor(path, string));
                Intrinsics.checkNotNullExpressionValue((Object)validateOf, (String)"ValidateOf.inValid(DataC\u2026sifier.simpleName ?: \"\"))");
                return validateOf;
            }
            KFunction constructor = (KFunction)CollectionsKt.first((Iterable)((KClass)classifier).getConstructors());
            boolean bl = false;
            List errors = new ArrayList();
            boolean bl2 = false;
            List missingMembers = new ArrayList();
            Object object2 = constructor.getParameters();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object t : $this$associateWithTo$iv$iv) {
                ValidateOf configNode;
                KParameter kParameter = (KParameter)t;
                Object t2 = t;
                Map map = result$iv;
                boolean bl3 = false;
                CharSequence charSequence = path;
                boolean bl4 = false;
                String nextPath = charSequence.length() > 0 ? path + '.' + it.getName() : it.getName();
                ValidateOf validateOf = configNode = decoderService.getNextNode(nextPath, it.getName(), node);
                Intrinsics.checkNotNullExpressionValue((Object)validateOf, (String)"configNode");
                List list = validateOf.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configNode.errors");
                errors.addAll(list);
                Object results = null;
                if (!it.isOptional() && !configNode.hasResults()) {
                    String string = it.getName();
                    if (string == null) {
                        string = "";
                    }
                    missingMembers.add(string);
                } else if (configNode.hasResults()) {
                    ValidateOf parameter = decoderService.decodeNode(nextPath, (ConfigNode)configNode.results(), (TypeCapture)KTypeCapture.Companion.of(it.getType()));
                    Boolean bl5 = parameter.hasErrors();
                    Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"parameter.hasErrors()");
                    if (bl5.booleanValue()) {
                        ValidateOf validateOf2 = parameter;
                        Intrinsics.checkNotNullExpressionValue((Object)validateOf2, (String)"parameter");
                        List list2 = validateOf2.getErrors();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parameter.errors");
                        errors.addAll(list2);
                    }
                    if (!parameter.hasResults()) {
                        errors.add(new ValidationError.NoResultsFoundForDecodingNode(nextPath, String.valueOf(it.getType().getClassifier())));
                    } else {
                        results = parameter.results();
                    }
                }
                Object object3 = results;
                map.put(t2, object3);
            }
            $this$associateWith$iv = result$iv;
            boolean $i$f$filterValues = false;
            result$iv = new LinkedHashMap();
            void var13_16 = $this$filterValues$iv;
            boolean bl6 = false;
            for (Map.Entry entry : var13_16.entrySet()) {
                it = entry.getValue();
                boolean bl7 = false;
                if (!(it != null)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            Map parameters = result$iv;
            object2 = missingMembers;
            $i$f$filterValues = false;
            if (!object2.isEmpty()) {
                String string = ((KClass)classifier).getSimpleName();
                if (string == null) {
                    string = "";
                }
                errors.add(new DataClassMissingRequiredMember(path, string, missingMembers));
                ValidateOf validateOf = ValidateOf.inValid((List)errors);
                object = validateOf;
                Intrinsics.checkNotNullExpressionValue((Object)validateOf, (String)"ValidateOf.inValid(errors)");
            } else {
                object2 = parameters;
                $i$f$filterValues = false;
                if (!object2.isEmpty()) {
                    ValidateOf validateOf = ValidateOf.validateOf((Object)constructor.callBy(parameters), (List)errors);
                    object = validateOf;
                    Intrinsics.checkNotNullExpressionValue((Object)validateOf, (String)"ValidateOf.validateOf(co\u2026llBy(parameters), errors)");
                } else {
                    try {
                        object2 = ValidateOf.validateOf((Object)KClasses.createInstance((KClass)((KClass)classifier)), (List)errors);
                    }
                    catch (IllegalArgumentException e) {
                        String string = ((KClass)classifier).getSimpleName();
                        if (string == null) {
                            string = "";
                        }
                        errors.add(new DataClassCanNotBeConstructed(path, string));
                        object2 = ValidateOf.inValid((List)errors);
                    }
                    Object object4 = object2;
                    object = object4;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"try {\n                  \u2026                        }");
                }
            }
            return object;
        }
        ValidateOf validateOf = ValidateOf.inValid((ValidationError)new DataClassCanNotBeConstructed(path, ""));
        Intrinsics.checkNotNullExpressionValue((Object)validateOf, (String)"ValidateOf.inValid(DataC\u2026tBeConstructed(path, \"\"))");
        return validateOf;
    }
}

