/*
 * Decompiled with CFR 0.152.
 */
package com.avocado.boot.starter.core.handler;

import com.avocado.boot.starter.core.exception.BusinessException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@ControllerAdvice
public class ExceptionAdviceHandler {
    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<?> bindExceptionHandler(BindException e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)((ObjectError)e.getAllErrors().get(0)).getDefaultMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<?> constraintViolationExceptionHandler(ConstraintViolationException e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)((ConstraintViolation)e.getConstraintViolations().iterator().next()).getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<?> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    public ResponseEntity<?> baseException(BusinessException e) {
        return ResponseEntity.status((int)e.getErrorType().getCode()).body((Object)e.getMessage());
    }
}

