/*
 * Decompiled with CFR 0.152.
 */
package com.avocado.boot.starter.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final long ONE_MILLIS = 1000L;
    private static final long ONE_MINUTE = 60L;
    private static final long ONE_HOUR = 3600L;
    private static final long ONE_DAY = 86400L;
    private static final long ONE_MONTH = 2592000L;
    private static final long ONE_YEAR = 31104000L;
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyyMMdd", "yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMM"};

    public static Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatCurrentDate() {
        return DateUtils.formatCurrentDate("yyyy-MM-dd");
    }

    public static String formatCurrentDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, String pattern) {
        String formatDate = null;
        formatDate = pattern != null ? DateFormatUtils.format((Date)date, (String)pattern) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static long getCurrentTimestamp() {
        long nowTimeStamp = Long.parseLong(DateUtils.getCurrentTimestampStr());
        return nowTimeStamp;
    }

    public static String getCurrentTimestampStr() {
        return DateUtils.formatDate(new Date(), "yyyyMMddHHmmss");
    }

    public static long getCurrentUnixTimestamp() {
        long nowTimeStamp = System.currentTimeMillis() / 1000L;
        return nowTimeStamp;
    }

    public static String getCurrentUnixTimestampStr() {
        return String.valueOf(DateUtils.getCurrentUnixTimestamp());
    }

    public static long parseUnixTimeStamp(long time) {
        return time / 1000L;
    }

    public static Date getBeforeWeek(Date date) {
        return DateUtils.getAddDate(date, 3, -1);
    }

    public static Date getBeforeDay(Date date) {
        return DateUtils.getAddDate(date, 6, -1);
    }

    public static Date getBeforeMouth(Date date) {
        return DateUtils.getAddDate(date, 2, -1);
    }

    public static Date getBeforeYear(Date date) {
        return DateUtils.getAddDate(date, 1, -1);
    }

    public static Date getAfterWeek(Date date) {
        return DateUtils.getAddDate(date, 3, 1);
    }

    public static Date getAfterDay(Date date) {
        return DateUtils.getAddDate(date, 6, 1);
    }

    public static Date getAfterMouth(Date date) {
        return DateUtils.getAddDate(date, 2, 1);
    }

    public static Date getAfterYear(Date date) {
        return DateUtils.getAddDate(date, 1, 1);
    }

    public static Date getAddDate(Date date, int field, int amount) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.add(field, amount);
        Date dateFrom = cl.getTime();
        return dateFrom;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatTime() {
        return DateUtils.formatDate(new Date(), "HH:mm:ss");
    }

    public static String formatCurrentDateTime() {
        return DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String formatMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String formatDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String formatWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static long getBeforeDays(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 86400000L;
    }

    public static long getBeforeHours(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 3600000L;
    }

    public static long getBeforeMinutes(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 60000L;
    }

    public static long getBeforeSeconds(Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 1000L;
    }

    public static double getDays(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static String formatTextFromtoday(Date createAt) {
        String interval = null;
        if (createAt == null) {
            return "";
        }
        long millisecond = System.currentTimeMillis() - createAt.getTime();
        long second = millisecond / 1000L;
        if (second <= 0L) {
            second = 0L;
        }
        if (second == 0L) {
            interval = "\u521a\u521a";
        } else if (second < 30L) {
            interval = second + "\u79d2\u4ee5\u524d";
        } else if (second >= 30L && second < 60L) {
            interval = "\u534a\u5206\u949f\u524d";
        } else if (second >= 60L && second < 3600L) {
            long minute = second / 60L;
            interval = minute + "\u5206\u949f\u524d";
        } else if (second >= 3600L && second < 86400L) {
            long hour = second / 60L / 60L;
            interval = hour + "\u5c0f\u65f6\u524d";
        } else if (second >= 86400L && second <= 172800L) {
            interval = "\u6628\u5929" + DateUtils.formatDate(createAt, "HH:mm");
        } else if (second >= 172800L && second <= 604800L) {
            long day = second / 60L / 60L / 24L;
            interval = day + "\u5929\u524d";
        } else {
            interval = second <= 31536000L && second >= 604800L ? DateUtils.formatDate(createAt, "MM-dd HH:mm") : (second >= 31536000L ? DateUtils.formatDate(createAt, "yyyy-MM-dd HH:mm") : "0");
        }
        return interval;
    }

    public static String formatTextFromDeadline(Date date) {
        long now;
        long deadline = date.getTime() / 1000L;
        long remain = deadline - (now = System.currentTimeMillis() / 1000L);
        if (remain <= 3600L) {
            return "\u53ea\u5269\u4e0b" + remain / 60L + "\u5206\u949f";
        }
        if (remain <= 86400L) {
            return "\u53ea\u5269\u4e0b" + remain / 3600L + "\u5c0f\u65f6" + remain % 3600L / 60L + "\u5206\u949f";
        }
        long day = remain / 86400L;
        long hour = remain % 86400L / 3600L;
        long minute = remain % 86400L % 3600L / 60L;
        return "\u53ea\u5269\u4e0b" + day + "\u5929" + hour + "\u5c0f\u65f6" + minute + "\u5206\u949f";
    }

    public static String unixTimeStamp2Date(String timestampString, String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        Long timestamp = Long.parseLong(timestampString) * 60L;
        String date = new SimpleDateFormat(pattern, Locale.CHINA).format(new Date(timestamp));
        return date;
    }

    public static String date2UnixTimeStamp(String dateStr, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return String.valueOf(sdf.parse(dateStr).getTime() / 60L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

