/*
 * Decompiled with CFR 0.152.
 */
package com.avocado.boot.starter.core.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;

public class JsonUtils {
    public static ObjectMapper getInstance() {
        return Holder.MAPPER;
    }

    public static String toJson(Object obj) throws JsonProcessingException {
        return Holder.MAPPER.writeValueAsString(obj);
    }

    public static <T> T toBean(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)Holder.MAPPER.readValue(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) throws JsonProcessingException {
        JavaType javaType = Holder.MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        return (List)Holder.MAPPER.readValue(json, javaType);
    }

    private static class Holder {
        private static final ObjectMapper MAPPER = new JsonMapper();

        private Holder() {
        }
    }

    private static class JsonMapper
    extends ObjectMapper {
        JsonMapper() {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.registerModule((Module)new JavaTimeModule());
            SimpleModule module = new SimpleModule();
            module.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            module.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            this.registerModule((Module)module);
        }
    }
}

