/*
 * Decompiled with CFR 0.152.
 */
package com.avocado.boot.starter.core.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final char SEPARATOR = '_';
    private static final String CHARSET = "UTF-8";
    private static List<Pattern> patterns = null;

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static Boolean toBoolean(Object val) {
        if (val == null) {
            return false;
        }
        return BooleanUtils.toBoolean((String)val.toString()) || "1".equals(val.toString());
    }

    public static String toString(Object obj, String defaultVal) {
        return obj == null ? defaultVal : obj.toString();
    }

    public static boolean inString(String str, String ... strs) {
        if (str != null) {
            for (String s : strs) {
                if (!str.equals(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }

    public static Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(StringUtils.toDouble(val).floatValue());
    }

    public static Long toLong(Object val) {
        return StringUtils.toDouble(val).longValue();
    }

    public static Integer toInteger(Object val) {
        return StringUtils.toLong(val).intValue();
    }

    public static String ellipsis(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : StringUtils.replaceHtml(StringEscapeUtils.unescapeHtml4((String)str)).toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("GBK").length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String replaceHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static String unescapeHtml(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml4((String)htmlEscaped);
    }

    public static String escapeXml(String xml) {
        return StringEscapeUtils.escapeXml11((String)xml);
    }

    public static String unescapeXml(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(param);
        Matcher mc = Pattern.compile(String.valueOf('_')).matcher(param);
        int i = 0;
        while (mc.find()) {
            int position = mc.end() - i++;
            sb.replace(position - 1, position + 1, sb.substring(position, position + 1).toUpperCase());
        }
        return sb.toString();
    }

    public static String formatBytes(long size) {
        int bytes = 1024;
        if (size < (long)bytes) {
            return String.valueOf(size) + "Byte";
        }
        if ((size /= (long)bytes) < (long)bytes) {
            return String.valueOf(size) + "K";
        }
        if ((size /= (long)bytes) < (long)bytes) {
            return String.valueOf((size *= 100L) / 100L) + "." + String.valueOf(size % 100L) + "M";
        }
        size = size * 100L / (long)bytes;
        return String.valueOf(size / 100L) + "." + String.valueOf(size % 100L) + "G";
    }

    public static String formatMobile(String mobile) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return null;
        }
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String formatBankCard(String bankCard) {
        if (StringUtils.isEmpty((CharSequence)bankCard)) {
            return null;
        }
        return bankCard.replaceAll("(\\d{5})\\d{5}\\d{2}(\\d{4})", "$1****$2");
    }

    public static String formatIdCard(String idCard) {
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            return null;
        }
        return idCard.replaceAll("(\\d{4})\\d{10}(\\w{4})", "$1*****$2");
    }

    public static boolean matchMobile(String mobile) {
        if (mobile == null) {
            return false;
        }
        String regex = "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|(147))\\d{8}$";
        return Pattern.matches(regex, mobile);
    }

    public static boolean matchEmail(String email) {
        if (email == null) {
            return false;
        }
        String regex = "\\w+@\\w+\\.[a-z]+(\\.[a-z]+)?";
        return Pattern.matches(regex, email);
    }

    public static boolean matchDomain(String domain) {
        if (domain == null) {
            return false;
        }
        String regex = "^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$";
        return Pattern.matches(regex, domain);
    }

    public static boolean matchIp(String ip) {
        if (ip == null) {
            return false;
        }
        String regex = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$";
        return Pattern.matches(regex, ip);
    }

    public static boolean matchHttpUrl(String url) {
        if (url == null) {
            return false;
        }
        String regex = "^(?=^.{3,255}$)(http(s)?:\\/\\/)?(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/\\w+\\.\\w+)*([\\?&]\\w+=\\w*)*$";
        return Pattern.matches(regex, url);
    }

    public static boolean matchBankCard(String bankCard) {
        if (bankCard == null) {
            return false;
        }
        if (bankCard.length() < 15 || bankCard.length() > 19) {
            return false;
        }
        char bit = StringUtils.getBankCardCheckCode(bankCard.substring(0, bankCard.length() - 1));
        if (bit == 'N') {
            return false;
        }
        return bankCard.charAt(bankCard.length() - 1) == bit;
    }

    public static char getBankCardCheckCode(String nonCheckCodeBankCard) {
        if (nonCheckCodeBankCard == null || nonCheckCodeBankCard.trim().length() == 0 || !nonCheckCodeBankCard.matches("\\d+")) {
            return 'N';
        }
        char[] chs = nonCheckCodeBankCard.trim().toCharArray();
        int luhmSum = 0;
        int i = chs.length - 1;
        int j = 0;
        while (i >= 0) {
            int k = chs[i] - 48;
            if (j % 2 == 0) {
                k *= 2;
                k = k / 10 + k % 10;
            }
            luhmSum += k;
            --i;
            ++j;
        }
        return luhmSum % 10 == 0 ? (char)'0' : (char)(10 - luhmSum % 10 + 48);
    }

    private static List<Object[]> getXssPatternList() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new Object[]{"<(no)?script[^>]*>.*?</(no)?script>", 2});
        ret.add(new Object[]{"eval\\((.*?)\\)", 42});
        ret.add(new Object[]{"expression\\((.*?)\\)", 42});
        ret.add(new Object[]{"(javascript:|vbscript:|view-source:)*", 2});
        ret.add(new Object[]{"<(\"[^\"]*\"|'[^']*'|[^'\">])*>", 42});
        ret.add(new Object[]{"(window\\.location|window\\.|\\.location|document\\.cookie|document\\.|alert\\(.*?\\)|window\\.open\\()*", 42});
        ret.add(new Object[]{"<+\\s*\\w*\\s*(oncontrolselect|oncopy|oncut|ondataavailable|ondatasetchanged|ondatasetcomplete|ondblclick|ondeactivate|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onerror=|onerroupdate|onfilterchange|onfinish|onfocus|onfocusin|onfocusout|onhelp|onkeydown|onkeypress|onkeyup|onlayoutcomplete|onload|onlosecapture|onmousedown|onmouseenter|onmouseleave|onmousemove|onmousout|onmouseover|onmouseup|onmousewheel|onmove|onmoveend|onmovestart|onabort|onactivate|onafterprint|onafterupdate|onbefore|onbeforeactivate|onbeforecopy|onbeforecut|onbeforedeactivate|onbeforeeditocus|onbeforepaste|onbeforeprint|onbeforeunload|onbeforeupdate|onblur|onbounce|oncellchange|onchange|onclick|oncontextmenu|onpaste|onpropertychange|onreadystatuschange|onreset|onresize|onresizend|onresizestart|onrowenter|onrowexit|onrowsdelete|onrowsinserted|onscroll|onselect|onselectionchange|onselectstart|onstart|onstop|onsubmit|onunload)+\\s*=+", 42});
        return ret;
    }

    private static List<Pattern> getPatterns() {
        if (patterns == null) {
            ArrayList<Pattern> list = new ArrayList<Pattern>();
            String regex = null;
            Integer flag = null;
            int arrLength = 0;
            for (Object[] arr : StringUtils.getXssPatternList()) {
                arrLength = arr.length;
                for (int i = 0; i < arrLength; ++i) {
                    regex = (String)arr[0];
                    flag = (Integer)arr[1];
                    list.add(Pattern.compile(regex, flag));
                }
            }
            patterns = list;
        }
        return patterns;
    }

    public static String stripXss(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Matcher matcher = null;
            for (Pattern pattern : StringUtils.getPatterns()) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                value = matcher.replaceAll("");
            }
            value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return value;
    }

    public static String checkPassword(String passwordStr) {
        String regexZ = "\\d*";
        String regexS = "[a-zA-Z]+";
        String regexT = "\\W+$";
        String regexZT = "\\D*";
        String regexST = "[\\d\\W]*";
        String regexZS = "\\w*";
        String regexZST = "[\\w\\W]*";
        if (passwordStr.matches(regexZ)) {
            return "\u5f31";
        }
        if (passwordStr.matches(regexS)) {
            return "\u5f31";
        }
        if (passwordStr.matches(regexT)) {
            return "\u5f31";
        }
        if (passwordStr.matches(regexZT)) {
            return "\u4e2d";
        }
        if (passwordStr.matches(regexST)) {
            return "\u4e2d";
        }
        if (passwordStr.matches(regexZS)) {
            return "\u4e2d";
        }
        if (passwordStr.matches(regexZST)) {
            return "\u5f3a";
        }
        return passwordStr;
    }

    public static String getExceptionToString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

