/*
 * Decompiled with CFR 0.152.
 */
package com.avocado.boot.starter.core.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

public class ValidateCodeUtils {
    public static final String CAPTCHA_CODE = "captcha";
    public static final int TYPE_NUM_ONLY = 0;
    public static final int TYPE_LETTER_ONLY = 1;
    public static final int TYPE_ALL_MIXED = 2;
    public static final int TYPE_NUM_UPPER = 3;
    public static final int TYPE_NUM_LOWER = 4;
    public static final int TYPE_UPPER_ONLY = 5;
    public static final int TYPE_LOWER_ONLY = 6;

    private ValidateCodeUtils() {
    }

    public static String getTextCode(int type, int length, String exChars) {
        if (length <= 0) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        int i = 0;
        Random r = new Random();
        switch (type) {
            case 0: {
                while (i < length) {
                    int t = r.nextInt(10);
                    if (exChars != null && exChars.indexOf(t + "") >= 0) continue;
                    code.append(t);
                    ++i;
                }
                break;
            }
            case 1: {
                while (i < length) {
                    int t = r.nextInt(123);
                    if (t < 97 && (t < 65 || t > 90) || exChars != null && exChars.indexOf((char)t) >= 0) continue;
                    code.append((char)t);
                    ++i;
                }
                break;
            }
            case 2: {
                while (i < length) {
                    int t = r.nextInt(123);
                    if (t < 97 && (t < 65 || t > 90) && (t < 48 || t > 57) || exChars != null && exChars.indexOf((char)t) >= 0) continue;
                    code.append((char)t);
                    ++i;
                }
                break;
            }
            case 3: {
                while (i < length) {
                    int t = r.nextInt(91);
                    if (t < 65 && (t < 48 || t > 57) || exChars != null && exChars.indexOf((char)t) >= 0) continue;
                    code.append((char)t);
                    ++i;
                }
                break;
            }
            case 4: {
                while (i < length) {
                    int t = r.nextInt(123);
                    if (t < 97 && (t < 48 || t > 57) || exChars != null && exChars.indexOf((char)t) >= 0) continue;
                    code.append((char)t);
                    ++i;
                }
                break;
            }
            case 5: {
                while (i < length) {
                    int t = r.nextInt(91);
                    if (t < 65 || exChars != null && exChars.indexOf((char)t) >= 0) continue;
                    code.append((char)t);
                    ++i;
                }
                break;
            }
            case 6: {
                while (i < length) {
                    int t = r.nextInt(123);
                    if (t < 97 || exChars != null && exChars.indexOf((char)t) >= 0) continue;
                    code.append((char)t);
                    ++i;
                }
                break;
            }
        }
        return code.toString();
    }

    public static BufferedImage getImageCode(String textCode, int width, int height) {
        return ValidateCodeUtils.getImageCode(textCode, width, height, 0, true, Color.white, Color.blue, null);
    }

    public static BufferedImage getImageCode(String textCode, int width, int height, int interLine, boolean randomLocation, Color backColor, Color foreColor, Color lineColor) {
        BufferedImage bim = new BufferedImage(width, height, 1);
        Graphics g = bim.getGraphics();
        g.setColor(backColor == null ? ValidateCodeUtils.getRandomColor() : backColor);
        g.fillRect(0, 0, width, height);
        Random r = new Random();
        if (interLine > 0) {
            int x = 0;
            int y = 0;
            int x1 = width;
            int y1 = 0;
            for (int i = 0; i < interLine; ++i) {
                g.setColor(lineColor == null ? ValidateCodeUtils.getRandomColor() : lineColor);
                y = r.nextInt(height);
                y1 = r.nextInt(height);
                g.drawLine(x, y, x1, y1);
            }
        }
        float yawpRate = 0.01f;
        int area = (int)(yawpRate * (float)width * (float)height);
        for (int i = 0; i < area; ++i) {
            int x = r.nextInt(width);
            int y = r.nextInt(height);
            bim.setRGB(x, y, r.nextInt(255));
        }
        int fCount = textCode.length();
        int fsize = (int)((double)height * 0.7);
        int fx = width / fCount;
        int fy = fsize;
        Font font = new Font("Fixedsys", 1, fsize);
        g.setFont(font);
        for (int i = 0; i < fCount; ++i) {
            fy = randomLocation ? (int)((Math.random() * 0.3 + 0.6) * (double)height) : fy;
            g.setColor(foreColor == null ? ValidateCodeUtils.getRandomColor() : foreColor);
            g.drawString(textCode.charAt(i) + "", fx * i + (0 < i && i < fCount ? 3 : 0), fy);
        }
        g.dispose();
        return bim;
    }

    public static BufferedImage getImageCode(int type, int length, String exChars, int width, int height, int interLine, boolean randomLocation, Color backColor, Color foreColor, Color lineColor) {
        String textCode = ValidateCodeUtils.getTextCode(type, length, exChars);
        BufferedImage bim = ValidateCodeUtils.getImageCode(textCode, width, height, interLine, randomLocation, backColor, foreColor, lineColor);
        return bim;
    }

    private static Color getRandomColor() {
        Random r = new Random();
        Color c = new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255));
        return c;
    }
}

