/*
 * Decompiled with CFR 0.152.
 */
package com.lanxiao.log.aop;

import com.lanxiao.core.exceptions.BusinessException;
import com.lanxiao.core.services.IOperatorService;
import com.lanxiao.core.utils.JsonUtils;
import com.lanxiao.log.annotations.Log;
import com.lanxiao.log.enums.LogLevelType;
import com.lanxiao.log.factory.LogConfigurationAdapter;
import com.lanxiao.log.properties.LogProperties;
import com.lanxiao.log.services.ILogOutputService;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Aspect
@EnableConfigurationProperties(value={LogProperties.class})
@ConditionalOnProperty(prefix="log", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LogAspect
extends HandlerInterceptorAdapter {
    private final ILogOutputService logOutput;
    private final IOperatorService operatorService;
    private final LogProperties logProperties;
    ThreadLocal<Long> startTime = new ThreadLocal();

    public LogAspect(LogConfigurationAdapter logConfigurationAdapter, LogProperties logProperties, IOperatorService operatorService) {
        this.operatorService = operatorService;
        this.logProperties = logProperties;
        this.logOutput = logConfigurationAdapter.getLogConfiguration(LogLevelType.valueOf(logProperties.getLevel()));
    }

    @Pointcut(value="@annotation(com.lanxiao.log.annotations.Log)")
    public void controllerAspect() {
    }

    @Before(value="controllerAspect()")
    public void before() {
        this.startTime.set(System.currentTimeMillis());
    }

    @AfterReturning(returning="ret", pointcut="controllerAspect()")
    public void doAfterReturning(JoinPoint joinPoint, Object ret) {
        HttpServletRequest request = this.getRequest();
        if (Objects.isNull(request) || this.isExclude(request)) {
            return;
        }
        com.lanxiao.log.domain.Log log = this.initLog(joinPoint, request);
        log.doAfterReturning(ret);
        this.logOutput.doAfterReturning(log, this.logProperties.isFormat());
    }

    @AfterThrowing(value="controllerAspect()", throwing="exception")
    public void doAfterThrowing(JoinPoint joinPoint, Exception exception) {
        HttpServletRequest request = this.getRequest();
        if (Objects.isNull(request) || this.isExclude(request)) {
            return;
        }
        com.lanxiao.log.domain.Log log = this.initLog(joinPoint, request);
        log.doAfterThrowing(exception);
        if (exception instanceof BusinessException) {
            this.logOutput.businessLog(log, this.logProperties.isFormat());
        } else {
            this.logOutput.doAfterThrowing(log, this.logProperties.isFormat());
        }
    }

    private com.lanxiao.log.domain.Log initLog(JoinPoint joinPoint, HttpServletRequest request) {
        Method method = this.getMethod(joinPoint);
        Log annotation = method.getAnnotation(Log.class);
        String parameter = "";
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] names = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
            Object[] objects = joinPoint.getArgs();
            for (int i = 0; i < names.length; ++i) {
                Object pam = objects[i];
                if (pam instanceof MultipartFile) {
                    pam = "[\u6587\u4ef6]";
                }
                map.put(names[i], pam);
            }
            parameter = JsonUtils.toJson(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new com.lanxiao.log.domain.Log(this.operatorService.operator(), annotation.businessType(), this.operatorService.operatorType(), method.getName(), annotation.discription(), request.getMethod(), request.getRequestURL().toString(), this.startTime.get(), parameter);
    }

    private Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        return signature.getMethod();
    }

    private boolean isExclude(HttpServletRequest request) {
        return this.logProperties.getExclude().contains(request.getMethod());
    }

    private HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return Objects.nonNull(attributes) ? attributes.getRequest() : null;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.startTime.remove();
    }
}

