/*
 * Decompiled with CFR 0.152.
 */
package com.lanxiao.log.domain;

import cn.hutool.core.date.DateUtil;
import com.lanxiao.core.utils.DateUtils;
import com.lanxiao.core.utils.JsonUtils;
import java.util.Date;

public class Log {
    private Object currUserId = "-";
    private String businessType;
    private Object operatorType;
    private Object outParam;
    private String inputParam;
    private String methodName;
    private String discription;
    private String method;
    private String url;
    private long consumingTime;
    private String startTime;
    private String endTime;
    private long startTimeMillis = 0L;
    private long endTimeMillis = 0L;
    private String errorTime;
    private Object errorCountent;

    public Log() {
    }

    public Log(Object currUserId, String businessType, Object operatorType, String methodName, String discription, String method, String url, long startTimeMillis, String inputParam) {
        this.currUserId = currUserId;
        this.businessType = businessType;
        this.operatorType = operatorType;
        this.methodName = methodName;
        this.discription = discription;
        this.method = method;
        this.url = url;
        this.startTime = DateUtils.formatDate((Date)DateUtil.date((long)startTimeMillis), (String)"yyyy-MM-dd HH:mm:ss");
        this.startTimeMillis = startTimeMillis;
        this.inputParam = inputParam;
    }

    public void doAfterReturning(Object ret) {
        Date date = new Date();
        this.setEndTime(DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        this.setEndTimeMillis(date.getTime());
        this.setOutParam(JsonUtils.toJson((Object)ret));
    }

    public void doAfterThrowing(Exception exception) {
        this.setErrorTime(DateUtils.formatCurrentDateTime());
        this.setErrorCountent(exception);
    }

    public Object getCurrUserId() {
        return this.currUserId;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Object getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(Object operatorType) {
        this.operatorType = operatorType;
    }

    public void setCurrUserId(Object currUserId) {
        this.currUserId = currUserId;
    }

    public Object getOutParam() {
        return this.outParam;
    }

    public void setOutParam(Object outParam) {
        this.outParam = outParam;
    }

    public String getInputParam() {
        return this.inputParam;
    }

    public void setInputParam(String inputParam) {
        this.inputParam = inputParam;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getDiscription() {
        return this.discription;
    }

    public void setDiscription(String discription) {
        this.discription = discription;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getConsumingTime() {
        return this.endTimeMillis - this.startTimeMillis;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public String getErrorTime() {
        return this.errorTime;
    }

    public void setErrorTime(String errorTime) {
        this.errorTime = errorTime;
    }

    public Object getErrorCountent() {
        return this.errorCountent;
    }

    public void setErrorCountent(Object errorCountent) {
        this.errorCountent = errorCountent;
    }
}

