/*
 * Decompiled with CFR 0.152.
 */
package com.lanxiao.log.services.impl;

import com.lanxiao.log.domain.Log;
import com.lanxiao.log.enums.LogLevelType;
import com.lanxiao.log.services.ILogOutputService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogOutputSupport
implements ILogOutputService {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogOutputSupport.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLogOutputSupport.class);

    @Override
    public abstract void businessLog(Log var1, boolean var2);

    @Override
    public abstract void doAfterReturning(Log var1, boolean var2);

    @Override
    public void doAfterThrowing(Log log, boolean isSingle) {
        if (isSingle) {
            LOGGER.error("\n\u8bf7\u6c42Url : {}\n\u8bf7\u6c42\u65b9\u5f0f : {}\n\u8bf7\u6c42\u65b9\u6cd5 : {}\n\u529f\u80fd\u6a21\u5757 : {}\n\u65b9\u6cd5\u63cf\u8ff0 : {}\n\u8bf7\u6c42\u7528\u6237 : {}\n\u7528\u6237\u7c7b\u522b : {}\n\u8bf7\u6c42\u53c2\u6570 : {}\n\u8bf7\u6c42\u5f00\u59cb\u65f6\u95f4\uff1a{}\n\u53d1\u751f\u5f02\u5e38\u65f6\u95f4 : {}\n\u629b\u51fa\u5f02\u5e38 : {}", new Object[]{log.getUrl(), log.getMethod(), log.getMethodName(), log.getBusinessType(), log.getDiscription(), log.getCurrUserId(), log.getOperatorType(), log.getInputParam(), log.getStartTime(), log.getErrorTime(), log.getErrorCountent()});
        } else {
            LOGGER.error("================================== Start ==================================");
            LOGGER.error("\u8bf7\u6c42Url : {}", (Object)log.getUrl());
            LOGGER.error("\u8bf7\u6c42\u65b9\u5f0f : {}", (Object)log.getMethod());
            LOGGER.error("\u8bf7\u6c42\u65b9\u6cd5 : {}", (Object)log.getMethodName());
            LOGGER.error("\u529f\u80fd\u6a21\u5757 : {}", (Object)log.getBusinessType());
            LOGGER.error("\u65b9\u6cd5\u63cf\u8ff0 : {}", (Object)log.getDiscription());
            LOGGER.error("\u8bf7\u6c42\u7528\u6237 : {}", log.getCurrUserId());
            LOGGER.error("\u7528\u6237\u7c7b\u522b : {}", log.getOperatorType());
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570 : {}", (Object)log.getInputParam());
            LOGGER.error("\u8bf7\u6c42\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)log.getStartTime());
            LOGGER.error("\u53d1\u751f\u5f02\u5e38\u65f6\u95f4\uff1a{}", (Object)log.getErrorTime());
            LOGGER.error("\u629b\u51fa\u5f02\u5e38: {}", log.getErrorCountent());
            LOGGER.error("================================== End ==================================");
        }
    }

    @Override
    public abstract LogLevelType getFlag();
}

