/*
 * Decompiled with CFR 0.152.
 */
package com.veeker.redis.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisUtil
implements AutoCloseable {
    private static RedisTemplate<String, Object> redisTemplate;

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisUtil.redisTemplate = redisTemplate;
    }

    private static long isLong(Long lo) {
        return Objects.nonNull(lo) ? lo : 0L;
    }

    private static boolean isBoolean(Boolean bol) {
        return Objects.nonNull(bol) ? bol : false;
    }

    public static boolean expire(String key, long time) {
        if (time > 0L) {
            return RedisUtil.isBoolean(redisTemplate.expire((Object)key, time, TimeUnit.SECONDS));
        }
        return false;
    }

    public static long getExpire(String key) {
        Long expire = redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
        return Objects.nonNull(expire) ? expire : -1L;
    }

    public static boolean isKey(String key) {
        return RedisUtil.isBoolean(redisTemplate.hasKey((Object)key));
    }

    public static Integer delete(String ... key) {
        if (key.length == 1) {
            Boolean delete = redisTemplate.delete((Object)key[0]);
            return Objects.nonNull(delete) && delete != false ? 1 : 0;
        }
        return Objects.requireNonNull(redisTemplate.delete(Arrays.asList(key))).intValue();
    }

    public static Object get(String key) {
        return redisTemplate.opsForValue().get((Object)key);
    }

    public static void set(String key, Object value) {
        redisTemplate.opsForValue().set((Object)key, value);
    }

    public static void set(String key, long time, Object value) {
        if (time > 0L) {
            redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
        } else {
            RedisUtil.set(key, value);
        }
    }

    public static long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return RedisUtil.isLong(redisTemplate.opsForValue().increment((Object)key, delta));
    }

    public static long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return RedisUtil.isLong(redisTemplate.opsForValue().increment((Object)key, -delta));
    }

    public static Object hashGet(String key, String item) {
        return redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public static Map<Object, Object> hashGet(String key) {
        return redisTemplate.opsForHash().entries((Object)key);
    }

    public static void hashsSet(String key, Map<String, Object> map) {
        redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public static void hashsSet(String key, Map<String, Object> map, long time) {
        redisTemplate.opsForHash().putAll((Object)key, map);
        if (time > 0L) {
            RedisUtil.expire(key, time);
        }
    }

    public static void hashsSet(String key, String item, Object value) {
        redisTemplate.opsForHash().put((Object)key, (Object)item, value);
    }

    public static void hashsSet(String key, String item, Object value, long time) {
        redisTemplate.opsForHash().put((Object)key, (Object)item, value);
        if (time > 0L) {
            RedisUtil.expire(key, time);
        }
    }

    public static void delectHash(String key, Object ... item) {
        redisTemplate.opsForHash().delete((Object)key, item);
    }

    public static boolean isHashKey(String key, String item) {
        return RedisUtil.isBoolean(redisTemplate.opsForHash().hasKey((Object)key, (Object)item));
    }

    public static double hashIncr(String key, String item, double by) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public static double hashDecr(String key, String item, double by) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public static Set<Object> hashKeysAll(String key) {
        return redisTemplate.opsForHash().keys((Object)key);
    }

    public static List<Object> hashValusAll(String key) {
        return redisTemplate.opsForHash().values((Object)key);
    }

    public static Set<Object> setGet(String key) {
        return redisTemplate.opsForSet().members((Object)key);
    }

    public static boolean setIsKey(String key, Object value) {
        return RedisUtil.isBoolean(redisTemplate.opsForSet().isMember((Object)key, value));
    }

    public static long setSet(String key, Object ... values) {
        return RedisUtil.isLong(redisTemplate.opsForSet().add((Object)key, values));
    }

    public static long setSetAndTime(String key, long time, Object ... values) {
        Long count = redisTemplate.opsForSet().add((Object)key, values);
        if (time > 0L) {
            RedisUtil.expire(key, time);
        }
        return RedisUtil.isLong(count);
    }

    public static long setGetSetSize(String key) {
        return RedisUtil.isLong(redisTemplate.opsForSet().size((Object)key));
    }

    public static long setRemove(String key, Object ... values) {
        return RedisUtil.isLong(redisTemplate.opsForSet().remove((Object)key, values));
    }

    public static List<Object> listGet(String key, long start, long end) {
        return redisTemplate.opsForList().range((Object)key, start, end);
    }

    public static List<Object> listGet(String key) {
        return RedisUtil.listGet(key, 0L, -1L);
    }

    public static long listGetListSize(String key) {
        return RedisUtil.isLong(redisTemplate.opsForList().size((Object)key));
    }

    public static Object listGetIndex(String key, long index) {
        return redisTemplate.opsForList().index((Object)key, index);
    }

    public static void listSingleSet(String key, Object value) {
        redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public static void listSingleSet(String key, Object value, long time) {
        redisTemplate.opsForList().rightPush((Object)key, value);
        if (time > 0L) {
            RedisUtil.expire(key, time);
        }
    }

    public static void listSet(String key, List<Object> value) {
        redisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    public static void listSet(String key, List<Object> value, long time) {
        redisTemplate.opsForList().rightPushAll((Object)key, value);
        if (time > 0L) {
            RedisUtil.expire(key, time);
        }
    }

    public static void listUpdateIndex(String key, long index, Object value) {
        redisTemplate.opsForList().set((Object)key, index, value);
    }

    public static long listRemove(String key, long count, Object value) {
        return RedisUtil.isLong(redisTemplate.opsForList().remove((Object)key, count, value));
    }

    @Override
    public void close() throws Exception {
        RedisConnectionUtils.unbindConnection((RedisConnectionFactory)Objects.requireNonNull(redisTemplate.getConnectionFactory()));
    }
}

