/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat;

import com.github.grossopa.hamster.selenium.component.mat.MatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import com.github.grossopa.selenium.core.component.DefaultWebComponent;
import com.github.grossopa.selenium.core.component.WebComponent;
import java.util.Objects;
import org.openqa.selenium.WebElement;

public abstract class AbstractMatComponent
extends DefaultWebComponent
implements MatComponent {
    protected final MatConfig config;

    protected AbstractMatComponent(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver);
        Objects.requireNonNull(config);
        this.config = config;
    }

    @Override
    public MatConfig getConfig() {
        return this.config;
    }

    public boolean isSelected() {
        return this.config.isChecked((WebComponent)this);
    }

    public boolean isEnabled() {
        return !this.config.isDisabled((WebComponent)this);
    }

    public abstract String getComponentName();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMatComponent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractMatComponent that = (AbstractMatComponent)o;
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.config);
    }

    public String toString() {
        return String.format("%s{element=%s}", this.getClass().getSimpleName(), this.element);
    }
}

