/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.config;

import com.github.grossopa.selenium.core.component.ComponentConfig;
import com.github.grossopa.selenium.core.component.WebComponent;
import java.util.Objects;

public class MatConfig
implements ComponentConfig {
    private String tagPrefix = "mat-";
    private String cssPrefix = "mat-";
    private String cdkPrefix = "cdk-";
    private String overlayAbsolutePath = "/html/body";

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        Objects.requireNonNull(tagPrefix);
        this.tagPrefix = tagPrefix;
    }

    public String getCssPrefix() {
        return this.cssPrefix;
    }

    public void setCssPrefix(String cssPrefix) {
        Objects.requireNonNull(cssPrefix);
        this.cssPrefix = cssPrefix;
    }

    public String getOverlayAbsolutePath() {
        return this.overlayAbsolutePath;
    }

    public void setOverlayAbsolutePath(String overlayAbsolutePath) {
        Objects.requireNonNull(overlayAbsolutePath);
        this.overlayAbsolutePath = overlayAbsolutePath;
    }

    public String getCdkPrefix() {
        return this.cdkPrefix;
    }

    public void setCdkPrefix(String cdkPrefix) {
        Objects.requireNonNull(cdkPrefix);
        this.cdkPrefix = cdkPrefix;
    }

    public String getIsCheckedCss() {
        return this.getCssPrefix() + "checked";
    }

    public String getIsSelectedCss() {
        return this.getCssPrefix() + "selected";
    }

    public String getIsDisabledCss() {
        return this.getCssPrefix() + "disabled";
    }

    public boolean isDisabled(WebComponent component) {
        return super.isDisabled(component) || "true".equalsIgnoreCase(component.getAttribute("aria-disabled"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatConfig)) {
            return false;
        }
        MatConfig matConfig = (MatConfig)o;
        return this.tagPrefix.equals(matConfig.tagPrefix) && this.cssPrefix.equals(matConfig.cssPrefix) && this.cdkPrefix.equals(matConfig.cdkPrefix) && this.overlayAbsolutePath.equals(matConfig.overlayAbsolutePath);
    }

    public int hashCode() {
        return Objects.hash(this.tagPrefix, this.cssPrefix, this.cdkPrefix, this.overlayAbsolutePath);
    }

    public String toString() {
        return "MatConfig{tagPrefix='" + this.tagPrefix + "', cssPrefix='" + this.cssPrefix + "', cdkPrefix='" + this.cdkPrefix + "', overlayAbsolutePath='" + this.overlayAbsolutePath + "'}";
    }

    public static MatConfig create(String tagPrefix, String cssPrefix, String cdkPrefix, String overlayAbsolutePath) {
        MatConfig config = new MatConfig();
        config.setTagPrefix(tagPrefix);
        config.setCssPrefix(cssPrefix);
        config.setCdkPrefix(cdkPrefix);
        config.setOverlayAbsolutePath(overlayAbsolutePath);
        return config;
    }
}

