/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.finder;

import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.hamster.selenium.component.mat.finder.MatOverlayFinder;
import com.github.grossopa.hamster.selenium.component.mat.main.MatMenu;
import com.github.grossopa.hamster.selenium.component.mat.main.MatOverlayContainer;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import com.github.grossopa.selenium.core.component.WebComponent;
import com.github.grossopa.selenium.core.locator.By2;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MatMenuItemFinder
extends MatOverlayFinder {
    public MatMenuItemFinder(ComponentWebDriver driver, MatConfig config) {
        super(driver, config);
    }

    public MatMenu findTopMenu(long delayInMillis) {
        return (MatMenu)this.driver.createWait(delayInMillis).until(d -> this.findTopMenu());
    }

    @Nullable
    public MatMenu findTopMenu() {
        List boxes;
        MatOverlayContainer container = this.findTopVisibleContainer();
        if (container != null && !(boxes = container.findComponents(By.className((String)(this.config.getCdkPrefix() + "overlay-connected-position-bounding-box")))).isEmpty()) {
            WebComponent topVisibleBox = (WebComponent)boxes.get(boxes.size() - 1);
            WebComponent panel = topVisibleBox.findComponent(By.className((String)(this.config.getCssPrefix() + "menu-panel")));
            return new MatMenu((WebElement)panel, this.driver, this.config);
        }
        return null;
    }

    public List<MatMenu> findMenus(long delayInMillis) {
        return (List)this.driver.createWait(delayInMillis).until(d -> this.findMenus());
    }

    public List<MatMenu> findMenus() {
        MatOverlayContainer container = this.findTopVisibleContainer();
        if (container != null) {
            return container.findComponentsAs(By2.xpathBuilder().anywhereRelative().attr("class").contains(this.config.getCdkPrefix() + "overlay-connected-position-bounding-box").descendant().attr("class").contains(this.config.getCssPrefix() + "menu-panel").build(), c -> new MatMenu((WebElement)c, this.driver, this.config));
        }
        return Lists.newArrayList();
    }

    @Override
    public String toString() {
        return "MatMenuItemFinder{driver=" + this.driver + ", config=" + this.config + "}";
    }
}

