/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.finder;

import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.hamster.selenium.component.mat.main.MatOverlayContainer;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MatOverlayFinder {
    protected final ComponentWebDriver driver;
    protected final MatConfig config;

    public MatOverlayFinder(ComponentWebDriver driver, MatConfig config) {
        Objects.requireNonNull(driver);
        Objects.requireNonNull(config);
        this.driver = driver;
        this.config = config;
    }

    public MatConfig getConfig() {
        return this.config;
    }

    public List<MatOverlayContainer> findContainers() {
        return this.driver.findComponentsAs(By.xpath((String)(this.config.getOverlayAbsolutePath() + String.format("/div[contains(@class,'%soverlay-container')]", this.config.getCdkPrefix()))), c -> new MatOverlayContainer((WebElement)c, this.driver, this.config));
    }

    public List<MatOverlayContainer> findVisibleContainers() {
        return this.findContainers().stream().filter(WebElement::isDisplayed).collect(Collectors.toList());
    }

    @Nullable
    public MatOverlayContainer findTopVisibleContainer() {
        List<MatOverlayContainer> containers = this.findVisibleContainers();
        return containers.isEmpty() ? null : containers.get(containers.size() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatOverlayFinder)) {
            return false;
        }
        MatOverlayFinder that = (MatOverlayFinder)o;
        return this.driver.equals(that.driver) && this.config.equals(that.config);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.config);
    }

    public String toString() {
        return "MatOverlayFinder{driver=" + this.driver + ", config=" + this.config + "}";
    }
}

