/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.action.AutocompleteCloseOptionsAction;
import com.github.grossopa.hamster.selenium.component.mat.action.AutocompleteOpenOptionsAction;
import com.github.grossopa.hamster.selenium.component.mat.action.CloseOptionsAction;
import com.github.grossopa.hamster.selenium.component.mat.action.OpenOptionsAction;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.hamster.selenium.component.mat.exception.OptionNotClosedException;
import com.github.grossopa.hamster.selenium.component.mat.finder.MatOverlayFinder;
import com.github.grossopa.hamster.selenium.component.mat.main.MatOverlayContainer;
import com.github.grossopa.hamster.selenium.component.mat.main.sub.MatOption;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import com.github.grossopa.selenium.core.component.WebComponent;
import com.github.grossopa.selenium.core.component.api.DelayedSelect;
import com.github.grossopa.selenium.core.component.api.Select;
import com.github.grossopa.selenium.core.locator.By2;
import com.github.grossopa.selenium.core.util.SeleniumUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

public class MatAutocomplete
extends AbstractMatComponent
implements Select,
DelayedSelect {
    protected static final AutocompleteOpenOptionsAction DEFAULT_OPEN_ACTION = new AutocompleteOpenOptionsAction();
    protected static final AutocompleteCloseOptionsAction DEFAULT_CLOSE_ACTION = new AutocompleteCloseOptionsAction();
    public static final String COMPONENT_NAME = "Autocomplete";
    private final MatOverlayFinder overlayFinder;
    private final By optionLocator;
    private final OpenOptionsAction openOptionsAction;
    private final CloseOptionsAction closeOptionsAction;

    public MatAutocomplete(WebElement element, ComponentWebDriver driver, MatConfig config) {
        this(element, driver, config, null, null, null, null);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "autocomplete-trigger");
    }

    public MatAutocomplete(WebElement element, ComponentWebDriver driver, MatConfig config, @Nullable MatOverlayFinder overlayFinder) {
        this(element, driver, config, overlayFinder, null, null, null);
    }

    public MatAutocomplete(WebElement element, ComponentWebDriver driver, MatConfig config, @Nullable MatOverlayFinder overlayFinder, @Nullable By optionLocator) {
        this(element, driver, config, overlayFinder, optionLocator, null, null);
    }

    public MatAutocomplete(WebElement element, ComponentWebDriver driver, MatConfig config, @Nullable MatOverlayFinder overlayFinder, @Nullable By optionLocator, @Nullable OpenOptionsAction openOptionsAction, @Nullable CloseOptionsAction closeOptionsAction) {
        super(element, driver, config);
        this.overlayFinder = (MatOverlayFinder)ObjectUtils.defaultIfNull((Object)overlayFinder, (Object)new MatOverlayFinder(driver, config));
        this.optionLocator = (By)ObjectUtils.defaultIfNull((Object)optionLocator, (Object)By2.tagName((String)(config.getTagPrefix() + "option")));
        this.openOptionsAction = (OpenOptionsAction)ObjectUtils.defaultIfNull((Object)openOptionsAction, (Object)DEFAULT_OPEN_ACTION);
        this.closeOptionsAction = (CloseOptionsAction)ObjectUtils.defaultIfNull((Object)closeOptionsAction, (Object)DEFAULT_CLOSE_ACTION);
    }

    public WebComponent getInput() {
        return this.findComponent(By2.xpathBuilder().anywhereRelative("input").attr("class").contains(this.config.getCssPrefix() + "autocomplete-trigger").build());
    }

    public List<WebComponent> getOptions2(Long delayInMillis) {
        return Lists.newArrayList((Iterable)this.openOptions(delayInMillis).findComponentsAs(this.optionLocator, c -> new MatOption((WebElement)c, this.driver, this.config)));
    }

    public List<WebComponent> getAllSelectedOptions2(Long delayInMillis) {
        return this.getOptions2().stream().filter(WebElement::isSelected).collect(Collectors.toList());
    }

    public WebComponent openOptions(Long delayInMillis) {
        Optional<WebComponent> autocompletePanel = this.tryToFindAutocompletePanel();
        if (autocompletePanel.isEmpty()) {
            this.openOptionsAction.open((WebComponent)this, this.driver);
        }
        autocompletePanel = delayInMillis <= 0L ? this.tryToFindAutocompletePanel() : Optional.of((WebComponent)this.driver.createWait(delayInMillis.longValue()).until(d -> this.tryToFindAutocompletePanel().orElse(null)));
        return autocompletePanel.orElseThrow(() -> new NoSuchElementException("failed to locate the autocomplete panel."));
    }

    public void closeOptions(Long delayInMillis) {
        Optional<WebComponent> autocompletePanel = this.tryToFindAutocompletePanel();
        if (autocompletePanel.isEmpty()) {
            return;
        }
        List options = autocompletePanel.get().findComponents(this.optionLocator);
        this.closeOptionsAction.close((WebComponent)this, options, this.driver);
        if (delayInMillis <= 0L) {
            autocompletePanel = this.tryToFindAutocompletePanel();
            if (autocompletePanel.isPresent() && autocompletePanel.get().isDisplayed()) {
                throw new OptionNotClosedException("Autocomplete panel is not properly closed.");
            }
        } else {
            WebDriverWait wait = this.driver.createWait(delayInMillis.longValue());
            wait.until(d -> {
                Optional<WebComponent> temp = this.tryToFindAutocompletePanel();
                return !temp.isPresent() || !temp.get().isDisplayed();
            });
        }
    }

    public WebElement getFirstSelectedOption(Long delayInMillis) {
        List<WebComponent> components = this.getAllSelectedOptions2(delayInMillis);
        return components.isEmpty() ? null : (WebElement)components.get(0);
    }

    public void selectByVisibleText(String text, Long delayInMillis) {
        List<WebComponent> options = this.getOptions2(delayInMillis);
        for (WebComponent option : options) {
            if (!StringUtils.equals((CharSequence)text, (CharSequence)option.getText())) continue;
            option.click();
            return;
        }
    }

    public void selectByIndex(int index, Long delayInMillis) {
        this.getOptions2(delayInMillis).get(index).click();
    }

    public void selectByValue(String value, Long delayInMillis) {
        this.selectByVisibleText(value, delayInMillis);
    }

    public void deselectAll(Long delayInMillis) {
        SeleniumUtils.cleanText((WebElement)this.getInput());
    }

    public void deselectByValue(String value, Long delayInMillis) {
        SeleniumUtils.cleanText((WebElement)this.getInput());
    }

    public void deselectByIndex(int index, Long delayInMillis) {
        SeleniumUtils.cleanText((WebElement)this.getInput());
    }

    public void deselectByVisibleText(String text, Long delayInMillis) {
        SeleniumUtils.cleanText((WebElement)this.getInput());
    }

    public List<WebComponent> getOptions2() {
        return this.getOptions2(0L);
    }

    public List<WebComponent> getAllSelectedOptions2() {
        return this.getAllSelectedOptions2(0L);
    }

    public WebComponent openOptions() {
        return this.openOptions(0L);
    }

    public void closeOptions() {
        this.closeOptions(0L);
    }

    public boolean isMultiple() {
        return false;
    }

    public WebElement getFirstSelectedOption() {
        return this.getFirstSelectedOption(0L);
    }

    public void selectByVisibleText(String text) {
        this.selectByVisibleText(text, 0L);
    }

    public void selectByIndex(int i) {
        this.selectByIndex(i, 0L);
    }

    public void selectByValue(String value) {
        this.selectByValue(value, 0L);
    }

    public void deselectAll() {
        this.deselectAll(0L);
    }

    public void deselectByValue(String value) {
        this.deselectByValue(value, 0L);
    }

    public void deselectByIndex(int i) {
        this.deselectByIndex(i, 0L);
    }

    public void deselectByVisibleText(String visibleText) {
        this.deselectByVisibleText(visibleText, 0L);
    }

    protected Optional<WebComponent> tryToFindAutocompletePanel() {
        MatOverlayContainer container = this.overlayFinder.findTopVisibleContainer();
        if (container != null) {
            List panels = container.findComponents(By2.className((String)(this.config.getCssPrefix() + "autocomplete-panel")));
            return panels.isEmpty() ? Optional.empty() : Optional.of((WebComponent)panels.get(panels.size() - 1));
        }
        return Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatAutocomplete)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatAutocomplete that = (MatAutocomplete)o;
        return this.overlayFinder.equals(that.overlayFinder) && this.optionLocator.equals((Object)that.optionLocator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.overlayFinder, this.optionLocator);
    }

    @Override
    public String toString() {
        return "MatAutocomplete{overlayFinder=" + this.overlayFinder + ", optionLocator=" + this.optionLocator + ", openOptionsAction=" + this.openOptionsAction + ", closeOptionsAction=" + this.closeOptionsAction + ", element=" + this.element + "}";
    }
}

