/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import com.github.grossopa.selenium.core.component.WebComponent;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MatExpansionPanel
extends AbstractMatComponent {
    public static final String COMPONENT_NAME = "ExpansionPanel";

    public MatExpansionPanel(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver, config);
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "expansion-panel");
    }

    @Override
    public boolean isEnabled() {
        return this.element.getAttribute("disabled") == null;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean isExpanded() {
        return this.attributeContains("class", this.config.getCssPrefix() + "expanded");
    }

    public void expand() {
        if (!this.isExpanded()) {
            this.getExpansionPanelHeader().click();
        }
    }

    public void collapse() {
        if (this.isExpanded()) {
            this.getExpansionPanelHeader().click();
        }
    }

    public WebComponent getExpansionPanelHeader() {
        return this.findComponent(By.className((String)(this.config.getCssPrefix() + "expansion-panel-header")));
    }

    public WebComponent getExpansionPanelBody() {
        return this.findComponent(By.className((String)(this.config.getCssPrefix() + "expansion-panel-body")));
    }
}

