/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.hamster.selenium.component.mat.exception.MenuItemNotFoundException;
import com.github.grossopa.hamster.selenium.component.mat.main.sub.MatMenuItem;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class MatMenu
extends AbstractMatComponent {
    public static final String COMPONENT_NAME = "Menu";

    public MatMenu(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver, config);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "menu-panel");
    }

    public List<MatMenuItem> getMenuItems() {
        return this.findComponentsAs(By.className((String)(this.config.getCssPrefix() + "menu-item")), c -> new MatMenuItem((WebElement)c, this.driver, this.config));
    }

    public MatMenu expandItemByIndex(int index, long animationInMillis, long topMenuDelayInMillis) {
        return this.getMenuItems().get(index).expand(animationInMillis, topMenuDelayInMillis);
    }

    public void selectItemByIndex(int index) {
        this.getMenuItems().get(index).click();
    }

    public MatMenu expandItemByText(String text, long animationInMillis, long topMenuDelayInMillis) {
        return this.actionBy(menuItem -> StringUtils.equals((CharSequence)text, (CharSequence)menuItem.getText()), menuItem -> menuItem.expand(animationInMillis, topMenuDelayInMillis));
    }

    public void selectItemByText(String text) {
        this.actionBy(menuItem -> StringUtils.equals((CharSequence)text, (CharSequence)menuItem.getText()), menuItem -> {
            menuItem.click();
            return null;
        });
    }

    public void close() {
        this.sendKeys(new CharSequence[]{Keys.ESCAPE});
    }

    private <T> T actionBy(Predicate<MatMenuItem> menuItemToSelectPredicate, Function<MatMenuItem, T> actionConsumer) {
        List<MatMenuItem> menuItems = this.getMenuItems();
        MatMenuItem item = menuItems.stream().filter(menuItemToSelectPredicate).findAny().orElseThrow(() -> new MenuItemNotFoundException("Menu item not found by predicate."));
        return actionConsumer.apply(item);
    }
}

