/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class MatProgressBar
extends AbstractMatComponent {
    public static final String COMPONENT_NAME = "ProgressBar";

    public MatProgressBar(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver, config);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "progress-bar");
    }

    public String getMinValue() {
        return this.getAttribute("aria-valuemin");
    }

    public String getMaxValue() {
        return this.getAttribute("aria-valuemax");
    }

    public String getValue() {
        return this.getAttribute("aria-valuenow");
    }

    public Mode getMode() {
        return Mode.valueOf(StringUtils.upperCase((String)this.getAttribute("mode")));
    }

    public static enum Mode {
        DETERMINATE,
        INDETERMINATE,
        BUFFER,
        QUERY;

    }
}

