/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import com.github.grossopa.selenium.core.component.WebComponent;
import com.github.grossopa.selenium.core.component.api.Slider;
import com.github.grossopa.selenium.core.component.util.WebComponentUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleConsumer;
import org.apache.commons.math3.util.Precision;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class MatSlider
extends AbstractMatComponent
implements Slider<WebComponent> {
    public static final String COMPONENT_NAME = "Slider";

    public MatSlider(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver, config);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "slider");
    }

    public String getValue() {
        return this.getAttribute("aria-valuenow");
    }

    public Integer getValueInteger() {
        return this.getValueDouble().intValue();
    }

    public Long getValueLong() {
        return this.getValueDouble().longValue();
    }

    public Double getValueDouble() {
        return Double.valueOf(this.getValue());
    }

    public String getMinValue() {
        return this.getAttribute("aria-valuemin");
    }

    public Integer getMinValueInteger() {
        return this.getMinValueDouble().intValue();
    }

    public Long getMinValueLong() {
        return this.getMinValueDouble().longValue();
    }

    public Double getMinValueDouble() {
        return Double.valueOf(this.getMinValue());
    }

    public String getMaxValue() {
        return this.getAttribute("aria-valuemax");
    }

    public Integer getMaxValueInteger() {
        return this.getMaxValueDouble().intValue();
    }

    public Long getMaxValueLong() {
        return this.getMaxValueDouble().longValue();
    }

    public Double getMaxValueDouble() {
        return Double.valueOf(this.getMaxValue());
    }

    public WebComponent getFirstThumb() {
        return this.findComponent(By.className((String)(this.config.getCssPrefix() + "slider-thumb")));
    }

    public List<WebComponent> getAllThumbs() {
        return Collections.singletonList(this.getFirstThumb());
    }

    public boolean isVertical() {
        return this.attributeContains("class", this.config.getCssPrefix() + "slider-vertical");
    }

    public boolean isInverted() {
        return this.attributeContains("class", this.config.getCssPrefix() + "slider-axis-inverted");
    }

    public void setValue(Integer value) {
        this.setValue(value.doubleValue());
    }

    public void setValue(int index, Integer value) {
        this.setValue(index, (Double)value.doubleValue());
    }

    public void setValue(WebComponent thumb, Integer value) {
        this.setValue(thumb, (Double)value.doubleValue());
    }

    public void setValue(Long value) {
        this.setValue(value.doubleValue());
    }

    public void setValue(int index, Long value) {
        this.setValue(index, (Double)value.doubleValue());
    }

    public void setValue(WebComponent thumb, Long value) {
        this.setValue(thumb, (Double)value.doubleValue());
    }

    public void setValue(Double value) {
        this.doSetValue(value, this::moveThumb);
    }

    public void setValue(int index, Double value) {
        this.doSetValue(value, percentage -> this.moveThumb(index, percentage));
    }

    public void setValue(WebComponent thumb, Double value) {
        this.doSetValue(value, percentage -> this.moveThumb(thumb, percentage));
    }

    public void moveThumb(double percentage) {
        this.moveThumb(this.getFirstThumb(), percentage);
    }

    public void moveThumb(int index, double percentage) {
        this.moveThumb(this.getAllThumbs().get(index), percentage);
    }

    private void doSetValue(Double value, DoubleConsumer moveThumbAction) {
        Double maxValue = this.getMaxValueDouble();
        Double minValue = this.getMinValueDouble();
        if (Precision.compareTo((double)value, (double)maxValue, (double)1.0E-4) == 1 || Precision.compareTo((double)value, (double)minValue, (double)1.0E-4) == -1) {
            throw new IllegalArgumentException(String.format("value %.2f is not in the range of %.2f, %.2f", value, minValue, maxValue));
        }
        moveThumbAction.accept((value - minValue) / (maxValue - minValue));
    }

    public void moveThumb(WebComponent thumb, double percentage) {
        double end;
        double start;
        if (Precision.compareTo((double)percentage, (double)1.0, (double)1.0E-4) == 1 || Precision.compareTo((double)percentage, (double)0.0, (double)1.0E-4) == -1) {
            throw new IllegalArgumentException("Percentage must be in range of [0.0, 1.0]");
        }
        Rectangle rect = this.element.findElement(By.className((String)(this.config.getCssPrefix() + "slider-wrapper"))).getRect();
        boolean vertical = this.isVertical();
        boolean inverted = this.isInverted();
        if (vertical) {
            start = rect.y + rect.height;
            end = rect.y;
        } else {
            start = rect.x;
            end = rect.x + rect.width;
        }
        if (vertical != inverted) {
            percentage = 1.0 - percentage;
        }
        Point thumbCenter = WebComponentUtils.getCenter((Rectangle)thumb.getRect());
        Actions actions = this.driver.createActions();
        int target = (int)Math.ceil(start + (end - start) * percentage);
        if (vertical) {
            actions.moveToElement(this.element).clickAndHold((WebElement)thumb).moveByOffset(0, target - thumbCenter.y).release().perform();
        } else {
            actions.moveToElement(this.element).clickAndHold((WebElement)thumb).moveByOffset(target - thumbCenter.x, 0).release().perform();
        }
    }
}

