/*
 * Decompiled with CFR 0.152.
 */
package com.github.grossopa.hamster.selenium.component.mat.main.sub;

import com.github.grossopa.hamster.selenium.component.mat.AbstractMatComponent;
import com.github.grossopa.hamster.selenium.component.mat.config.MatConfig;
import com.github.grossopa.selenium.core.ComponentWebDriver;
import com.github.grossopa.selenium.core.component.WebComponent;
import com.github.grossopa.selenium.core.locator.By2;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MatChip
extends AbstractMatComponent {
    public static final String COMPONENT_NAME = "Chip";

    public MatChip(WebElement element, ComponentWebDriver driver, MatConfig config) {
        super(element, driver, config);
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public boolean validate() {
        return this.attributeContains("class", this.config.getCssPrefix() + "chip");
    }

    public WebComponent getRemoveIcon() {
        return this.findComponent(this.removeIconLocator());
    }

    private By removeIconLocator() {
        return By2.xpathBuilder().anywhereRelative(this.config.getTagPrefix() + "icon").attr("class").contains(this.config.getCssPrefix() + "chip-remove").build();
    }

    public String getText() {
        String removeIconText;
        String fullText = super.getText();
        List removeIcon = this.findComponents(this.removeIconLocator());
        if (!removeIcon.isEmpty() && fullText.endsWith(removeIconText = ((WebComponent)removeIcon.get(0)).getText())) {
            return fullText.substring(0, fullText.length() - removeIconText.length() - 1);
        }
        return fullText;
    }
}

